<?php

include_once DOKU_INC.'lib/plugins/loki/utl/loki_utl_ask.php';
include_once DOKU_INC.'lib/plugins/loki/utl/loki_utl_sparql.php';

class LokiUtlUnitTest  { 

	private $tests_info;

	public function run_all_unit_tests($namespace, $page_name)
	{
		$unittests_dir = getcwd()."/data/pages/unittest/";
		$this->tests_info = $this->count_tests_and_init_tests_info("");
		$files = scandir($unittests_dir);
		$utla= new LokiUtlAsk;
		$utls= new LokiUtlSparql;
		$this->execute_tests_in_dir("");
		$tests_output = "Reasoning unit tests results:\n\n";
		$tests_output = $tests_output."^ Test ^ Status ^\n";

		foreach ($this->tests_info["tests"] as $key => $value) {
			$testpath = str_replace('/', ':', substr($key, 0, -4));
			if($value==0) {
				$tests_output = $tests_output."|[[unittestresults:".$testpath."|".$testpath."]]| PASSED|\n";
			} elseif ($value==1) {
				$tests_output = $tests_output."|[[unittestresults:".$testpath."|".$testpath."]]| FAILED|\n";
			} else {
				$tests_output = $tests_output."|[[unittestresults:".$testpath."|".$testpath."]]| NOT EXECUTED|\n";
			}
		}
		io_saveFile(getcwd()."/data/pages/unittestsoverview.txt", $tests_output, false);
	}

	private function count_tests_and_init_tests_info($directory) {
		$unittests_dir = getcwd()."/data/pages/unittest/";
		$result = 0;
		$result_arr=[];
		$return_array = [];
		$files = scandir($unittests_dir.$directory);
		for($i=0; $i<count($files); $i++) {
			$file = $files[$i];
			if($file == "." || $file == "..") {
				continue;
			}
			if (is_file($unittests_dir.$directory.$file)) {
				$result++;
				$result_arr[$directory.$file]=-1;
			} else if (is_dir($unittests_dir.$directory.$file)) {
				$subdir_results = $this->count_tests_and_init_tests_info($directory.$file."/");
				$result_arr = array_merge($result_arr, $subdir_results["tests"]);
				$result = $result + $subdir_results["amount"];
			}
		}
		$return_array["amount"] = $result;
		$return_array["tests"] = $result_arr;
		
		//save number of tests inside lib/plugins/loki/test_no.txt file
		io_saveFile(getcwd()."/lib/plugins/loki/test_no.txt", $result, false);
		
		return $return_array;
	}

	private function execute_test($relative_file_path) {
		$utla= new LokiUtlAsk;
		$utls= new LokiUtlSparql;
		$file = io_readFile(getcwd()."/data/pages/unittest/".$relative_file_path);
		$any_fail = false;
		
		//checking if ASK test
		$matches = null;
		$tests_output = "[[category:unittest]]\n===== Test results ===== \n";
		$isAsk = preg_match("{{.*#ask:.*}}", $file, $matches);
		if($isAsk == 1) {
			$query = substr($matches[0], 2, -2);
			$tests_output = $tests_output."==== Query result ====\n".$matches[0]."\n";
			$query_result = $utla->process_ask($query)["result"];
			$test_conditions = $this->read_all_test_conditions($relative_file_path);
			for ($j = 0; $j < $test_conditions["count"]; $j++) 
			{
				$test_result = $this->assert_test_condition($query_result, $test_conditions["types"][$j], $test_conditions["values"][$j]);
				$tests_output = $tests_output."Test: ".$test_result["condition_type"]."; Value: ".$test_result["condition_value"]."; Result: ".$test_result["test_result"]."//\n";
				$any_fail = $any_fail || (($test_result["test_result"]=="FAILED") || ($test_result["test_result"] == "ERROR: Assertion type unknown! "));
			}
		} else {
			$isSparql = false;
			$matches = null;
			$isSparql = preg_match('#<\s*?pl\s\b[^>]*sparql\b[^>]*>(.*?)</pl\b[^>]*>#s', $file, $matches);
			if($isSparql == 0 || count($matches)==0) {
				// no match for sparql test
				// continue;
				return $any_fail;
			} else {
				$query = $matches[1];
				$tests_output = $tests_output."==== Query result ====\n".$matches[0]."\\\\\n";
				$querytype = null;
				$sliced_query = preg_split("/(prefix|select|ask|construct|describe|where|order by|limit|offset)/i",trim($query), -1, PREG_SPLIT_DELIM_CAPTURE|PREG_SPLIT_NO_EMPTY);
				for ($i=0; $i<count($sliced_query); $i+=2){
					$keyword = strtolower($sliced_query[$i]);
					if(in_array($keyword, array("select","ask","describe"))) {
						$querytype = $keyword;
						break;
					}
				}
				if($querytype==null) {
					return $any_fail;
				}
				$query_result = json_decode($utls->process_sparql($query, $a=null, "json"), true);
				$test_conditions = $this->read_all_test_conditions_for_sparql_test($relative_file_path);
				for ($j = 0; $j < $test_conditions["count"]; $j++) 
				{
					if($querytype == "select") {
						$test_result = $this->assert_test_condition_sparql_select($query_result, $test_conditions["types"][$j], $test_conditions["fields"][$j], $test_conditions["values"][$j]);
					} elseif ($querytype == "describe") {
						$test_result = $this->assert_test_condition_sparql_describe($query_result, $test_conditions["types"][$j], $test_conditions["fields"][$j], $test_conditions["values"][$j]);
					} else {
						$test_result = $this->assert_test_condition_sparql_ask($query_result, $test_conditions["types"][$j]);
					}
					if($querytype == "ask") {
						$tests_output = $tests_output."Test: ".$test_result["condition_type"]."; Result: ".$test_result["test_result"]."\\\\\n";
					} else {
						$tests_output = $tests_output."Test: ".$test_result["condition_type"]."; Field ".$test_result["condition_field"]."; Value: ".$test_result["condition_value"]." Result: ".$test_result["test_result"]."\\\\\n";
					}
					$any_fail = $any_fail || (($test_result["test_result"]=="FAILED") || ($test_result["test_result"] == "ERROR: Assertion type unknown! "));
				}
			}
		}
		io_saveFile(getcwd()."/data/pages/unittestresults/".$relative_file_path, $tests_output, false);
		return $any_fail;
	}

	private function set_test_status($relative_file_path, $test_failed) {
		$this->tests_info["tests"][$relative_file_path] = $test_failed;
	}

	private function execute_tests_in_dir($directory) {
		$any_fail = false;
		$unittests_dir = getcwd()."/data/pages/unittest/";
		$files = scandir($unittests_dir.$directory);
		$tests_succeeded = 0;
		$tests_failed = 0;
		$dir_array = array();
		for($i=0; $i<count($files); $i++) {
			$file = $files[$i];
			if($file == "." || $file == "..") {
				continue;
			}
			if (is_file($unittests_dir.$directory.$file)) {
				$test_failed = $this->execute_test($directory.$file);
				if($test_failed) {
					$tests_failed++;
					$this->set_test_status($directory.$file, 1);
					$any_fail = true;
				} else {
					$tests_succeeded++;
					$this->set_test_status($directory.$file, 0);
				}
			} else if (is_dir($unittests_dir.$directory.$file)) {
				$dir_array.array_push($dir_array, $directory.$file."/");
			}
		}
		if (!$any_fail) {
			for ($i=0; $i < count($dir_array); $i++) {
				$subdirectory_tests = $this->execute_tests_in_dir($dir_array[$i]);
				$tests_succeeded = $tests_succeeded + $subdirectory_tests["success"];
				$tests_failed = $tests_failed + $subdirectory_tests["failure"];
			}
		}
		$return_array = [];
		$return_array["success"] = $tests_succeeded;
		$return_array["failure"] = $tests_failed;
		return $return_array;
	}

	private function assert_test_condition($test_results, $condition_type, $condition_value)
	{
		$result = array();
		$test_result = null;
		if($condition_type == "anyequal")
		{
			$test_result = "FAILED";
			for ($i = 0; $i < count($test_results); $i++) 
			{
				if($test_results[$i][1] == $condition_value)
				{
					$test_result = "PASSED";
				}
			}
		}
		else if($condition_type == "allequal")
		{
			$test_result = "PASSED";
			for ($i = 0; $i < count($test_results); $i++) 
			{
				if($test_results[$i][1] != $condition_value)
				{
					$test_result = "FAILED";
				}
			}
		}
		else if($condition_type == "noneequal")
		{
			$test_result = "PASSED";
			for ($i = 0; $i < count($test_results); $i++) 
			{
				if($test_results[$i][1] == $condition_value)
				{
					$test_result = "FAILED";
				}
			}
		}
		else if($condition_type == "countequal")
		{
			$test_result = count($test_results) == $condition_value ? "PASSED" : "FAILED";
		}
		else if($condition_type == "countnotequal")
		{
			$test_result = count($test_results) != $condition_value ? "PASSED" : "FAILED";
		}
		else if($condition_type == "countlesserequal")
		{
			$test_result = count($test_results) <= $condition_value ? "PASSED" : "FAILED";
		}
		else if($condition_type == "countlesser")
		{
			$test_result = count($test_results) < $condition_value ? "PASSED" : "FAILED";
		}
		else if($condition_type == "countgreaterequal")
		{
			$test_result = count($test_results) >= $condition_value ? "PASSED" : "FAILED";
		}
		else if($condition_type == "countgreater")
		{
			$test_result = count($test_results) > $condition_value ? "PASSED" : "FAILED";
		}
		else
		{
			$test_result = "ERROR: Assertion type unknown! ";
		}
		$result["condition_type"] = $condition_type;
		$result["condition_value"] = $condition_value;
		$result["test_result"] = $test_result;
		return $result;
	}

	private function assert_test_condition_sparql_describe($test_results, $condition_type, $condition_field, $condition_value)
	{
		$result = array();
		$working_array = array();
		for ($i = 0; $i < count($test_results); $i++) {
			$working_array[$test_results[$i][0]][$test_results[$i][1]][count($working_array[$test_results[$i][0]][$test_results[$i][1]])] = $test_results[$i][2];
		}
		$test_result = null;
		if($condition_type == "anyequal")
		{
			if($condition_field == null) {
				$test_result = "FAILED";
			} else {
				$test_result = "FAILED";
				for ($i = 0; $i < count($test_results); $i++) 
				{
					if($test_results[$i][1] == $condition_field)
					{
						if($test_results[$i][2] == $condition_value) {
							$test_result = "PASSED";
							break;
						}
					}
				}
			}
		}
		else if($condition_type == "allequal")
		{
			if($condition_field == null) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				foreach ($working_array as $page => $value) {
					$page_contains_valid_argument = false;
					for($i = 0; $i < count($value[$condition_field]); $i++) {
						if($value[$condition_field][$i] == $condition_value) {
							$page_contains_valid_argument = true;
							break;
						}
					}
					if($page_contains_valid_argument === false) {
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "noneequal")
		{
			if($condition_field == null) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				foreach ($working_array as $page => $value) {
					$page_contains_valid_argument = false;
					for($i = 0; $i < count($value[$condition_field]); $i++) {
						if($value[$condition_field][$i] == $condition_value) {
							$page_contains_valid_argument = true;
							break;
						}
					}
					if($page_contains_valid_argument === true) {
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "pagecount") {
			if(!is_numeric($condition_value)) {
				$test_result = "FAILED";
			} else {
				switch ($condition_field) {
					case 'less':
						$test_result = count($working_array) < $condition_value ? "PASSED" : "FAILED";
						break;
					case 'lessequal':
						$test_result = count($working_array) <= $condition_value ? "PASSED" : "FAILED";
						break;
					case 'equal':
						$test_result = count($working_array) == $condition_value ? "PASSED" : "FAILED";
						break;
					case 'notequal':
						$test_result = count($working_array) != $condition_value ? "PASSED" : "FAILED";
						break;
					case 'greaterequal':
						$test_result = count($working_array) >= $condition_value ? "PASSED" : "FAILED";
						break;				
					case 'greater':
						$test_result = count($working_array) > $condition_value ? "PASSED" : "FAILED";
						break;
					default:
						$test_result = "ERROR: Assertion type unknown! ";
						break;
				}
			}
		}
		else if($condition_type == "attributecountless") {
			if(!is_numeric($condition_value)) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				foreach ($working_array as $page => $value) {
					if(!(count($value[$condition_field]) < $condition_value)) {
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "attributecountlessequal") {
			if(!is_numeric($condition_value)) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				foreach ($working_array as $page => $value) {
					if(!(count($value[$condition_field]) <= $condition_value)) {
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "attributecountequal") {
			if(!is_numeric($condition_value)) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				foreach ($working_array as $page => $value) {
					if(!(count($value[$condition_field]) == $condition_value)) {
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "attributecountnotequal") {
			if(!is_numeric($condition_value)) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				foreach ($working_array as $page => $value) {
					if(!(count($value[$condition_field]) != $condition_value)) {
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "attributecountgreaterequal") {
			if(!is_numeric($condition_value)) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				foreach ($working_array as $page => $value) {
					if(!(count($value[$condition_field]) >= $condition_value)) {
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "attributecountgreater") {
			if(!is_numeric($condition_value)) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				foreach ($working_array as $page => $value) {
					if(!(count($value[$condition_field]) > $condition_value)) {
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else
		{
			$test_result = "ERROR: Assertion type unknown! ";
		}
		$result["condition_type"] = $condition_type;
		$result["condition_field"] = $condition_field;
		$result["condition_value"] = $condition_value;
		$result["test_result"] = $test_result;
		return $result;
	}

	private function assert_test_condition_sparql_ask($test_results, $condition_type)
	{
		$result = array();
		$test_result = null;

		if($condition_type == "asserttrue")
		{
			$test_result = $test_results === true ? "PASSED" : "FAILED";
		}
		else if($condition_type == "assertfalse")
		{
			$test_result = $test_results === false ? "PASSED" : "FAILED";
		}
		else
		{
			$test_result = "ERROR: Assertion type unknown! ";
		}
		$result["condition_type"] = $condition_type;
		$result["test_result"] = $test_result;
		return $result;
	}


	private function assert_test_condition_sparql_select($test_results, $condition_type, $condition_field, $condition_value)
	{
		$result = array();
		$test_result = null;
		if($condition_type == "anyequal")
		{
			if($condition_field == null) {
				$test_result = "FAILED";
			} else {
				$test_result = "FAILED";
				for ($i = 0; $i < count($test_results); $i++) 
				{
					if($test_results[$i][$condition_field] == $condition_value)
					{
						$test_result = "PASSED";
						break;
					}
				}
			}
		}
		else if($condition_type == "allequal")
		{
			if($condition_field == null) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				for ($i = 0; $i < count($test_results); $i++) 
				{
					if($test_results[$i][$condition_field] != $condition_value)
					{
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "noneequal")
		{
			if($condition_field == null) {
				$test_result = "FAILED";
			} else {
				$test_result = "PASSED";
				for ($i = 0; $i < count($test_results); $i++) 
				{
					if($test_results[$i][$condition_field] == $condition_value)
					{
						$test_result = "FAILED";
						break;
					}
				}
			}
		}
		else if($condition_type == "rowcount") {
			if(!is_numeric($condition_value)) {
				$test_result = "FAILED";
			} else {
				switch ($condition_field) {
					case 'less':
						$test_result = count($test_results) < $condition_value ? "PASSED" : "FAILED";
						break;
					case 'lessequal':
						$test_result = count($test_results) <= $condition_value ? "PASSED" : "FAILED";
						break;
					case 'equal':
						$test_result = count($test_results) == $condition_value ? "PASSED" : "FAILED";
						break;
					case 'notequal':
						$test_result = count($test_results) != $condition_value ? "PASSED" : "FAILED";
						break;
					case 'greaterequal':
						$test_result = count($test_results) >= $condition_value ? "PASSED" : "FAILED";
						break;				
					case 'greater':
						$test_result = count($test_results) > $condition_value ? "PASSED" : "FAILED";
						break;
					default:
						$test_result = "ERROR: Assertion type unknown! ";
						break;
				}
			}
		}
		else
		{
			$test_result = "ERROR: Assertion type unknown! ";
		}
		$result["condition_type"] = $condition_type;		
		$result["condition_field"] = $condition_field;
		$result["condition_value"] = $condition_value;
		$result["test_result"] = $test_result;
		return $result;
	}

	private function read_all_test_conditions($file_path)
	{
		$file_content = io_readFile(getcwd()."/lib/plugins/loki/tmp/loki/unittest/".$file_path);
		$matches = null;
		preg_match_all("/wiki_attribute.*unittest_assert_.*/", $file_content, $matches);

		$condition_types = array();
		$condition_values = array();
		for ($i = 0; $i < count($matches[0]); $i++) 
		{
			$condition_line = $matches[0][$i];
			$param_matches = null;
			preg_match("/unittest_assert_(.*?)\'/", $condition_line, $param_matches);
			$param_type = $param_matches[1];
			preg_match("/unittest_assert_".$param_type."\'\,\'(.*?)\'/", $condition_line, $param_matches);
			$param_value = $param_matches[1];

			$condition_types[$i] = $param_type;
			$condition_values[$i] = $param_value;
		}
		$result = array();
		$result["types"] = $condition_types;
		$result["values"] = $condition_values;
		$result["count"] = count($matches[0]);

		return $result;
	}

	private function read_all_test_conditions_for_sparql_test($file_path)
	{
		$file_content = io_readFile(getcwd()."/lib/plugins/loki/tmp/loki/unittest/".$file_path);
		$matches = null;
		preg_match_all("/wiki_testassert.*unittest_assert_.*/", $file_content, $matches);

		$condition_types = array();
		$condition_fields = array();
		$condition_values = array();
		for ($i = 0; $i < count($matches[0]); $i++) 
		{
			$condition_line = $matches[0][$i];
			$param_matches = null;
			preg_match("/unittest_assert_(.*?)\'/", $condition_line, $param_matches);
			$param_type = $param_matches[1];
			preg_match("/unittest_assert_".$param_type."\'\,\'([^:]*?):([^\|]*?)\'/", $condition_line, $param_matches);
			$param_field = $param_matches[1];
			$param_value = $param_matches[2];


			$condition_types[$i] = $param_type;
			$condition_fields[$i] = $param_field;
			$condition_values[$i] = $param_value;
		}
		$result = array();
		$result["types"] = $condition_types;
		$result["fields"] = $condition_fields;
		$result["values"] = $condition_values;
		$result["count"] = count($matches[0]);

		return $result;
	}
}
?>
