<?php

 /**
 * Loki Refresh Script - Script that refreshes cache (prolog cache in Loki and 'standard'
 *                       DokuWiki cache. To achieve this, script opens every page in
 *                       specified namespaces (each namespace is one use case). While
 *                       page is opened, cache is automatically refreshed.
 *
 * @author		GEIST Research Group <geist@agh.edu.pl>
 */


/******  PACKAGE SPECIFIC CONFIG  ******/

$use_cases = array("bookstore", "cities", "countries", "football_teams", "languages", "movies", "persons");


/******  GENERAL SCRIPT FOR LOKI USE CASES  ******/

if (!file_exists('doku.php')){
    echo "ERROR: Script should be placed in main DokuWiki directory!";
    die();
}


//specify which userewrite type is used in DokuWiki:
$dokuwiki_prefix = "doku.php?id=";
require 'conf/local.php';
if(isset($conf['userewrite'])){
    switch ($conf['userewrite']) {
        case 0:
            //default "doku.php?id="
            break;
        case 1:
            $dokuwiki_prefix = "";
            break;
        case 2:
            $dokuwiki_prefix = "doku.php/";
            break;
    }
}


//absolute pages directory:
$pages_dir = getcwd().'/data/pages/';

//wiki location -- full base URI, e.g. http://loki.ia.agh.edu.pl/wiki/
$wiki_relative_uri = substr($_SERVER['REQUEST_URI'], 0, strlen($_SERVER['REQUEST_URI']) - strlen(strrchr($_SERVER['REQUEST_URI'], "/")));
$protocol = "http://";
if(isset($_SERVER['HTTPS'])) {  $protocol = "https://";  }
$wiki_location = $protocol.$_SERVER['HTTP_HOST'].$wiki_relative_uri.'/';


//prepare and explore URLs for each page in each specified use case:
foreach($use_cases as $case){
    echo "Refreshing cache in \"$case\" case...";

    $Directory = new RecursiveDirectoryIterator($pages_dir.$case);
    $Iterator = new RecursiveIteratorIterator($Directory);
    $Regex = new RegexIterator($Iterator, '/^.+\.txt$/i', RecursiveRegexIterator::GET_MATCH);

    foreach($Regex as $name => $Regex){
        //get relative path for each file (and remove ".txt" at the end):
        $wiki_page_uri = substr($name, strlen($pages_dir), strlen($name)-strlen($pages_dir)-4);
        //change "/" into ":"
        $wiki_page_uri = str_replace("/", ":", $wiki_page_uri);
        //concatenate parts into final page uri:
        $wiki_page_uri = $wiki_location.$wiki_page_uri;

        //open page to refresh cache (get only 1 byte to reduce transfer)
        file_get_contents($wiki_page_uri,0,null,0,1);
    }

    echo "DONE!<br />";
}

?>
