/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.acearth.PSystemXearthFactory1317;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory1317;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3_1317;
import net.sourceforge.plantuml.api.PSystemFactory1317;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory1317;
import net.sourceforge.plantuml.compositediagram.CompositeDiagramFactory1317;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory1317;
import net.sourceforge.plantuml.directdot.PSystemDotFactory1317;
import net.sourceforge.plantuml.ditaa.PSystemDitaaFactory1317;
import net.sourceforge.plantuml.donors.PSystemDonorsFactory1317;
import net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory1317;
import net.sourceforge.plantuml.eggs.PSystemEggFactory1317;
import net.sourceforge.plantuml.eggs.PSystemLostFactory1317;
import net.sourceforge.plantuml.eggs.PSystemPathFactory1317;
import net.sourceforge.plantuml.eggs.PSystemRIPFactory1317;
import net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory1317;
import net.sourceforge.plantuml.font.PSystemListFontsFactory1317;
import net.sourceforge.plantuml.jcckit.PSystemJcckitFactory1317;
import net.sourceforge.plantuml.logo.PSystemLogoFactory1317;
import net.sourceforge.plantuml.objectdiagram.ObjectDiagramFactory1317;
import net.sourceforge.plantuml.oregon.PSystemOregonFactory1317;
import net.sourceforge.plantuml.postit.PostIdDiagramFactory1317;
import net.sourceforge.plantuml.printskin.PrintSkinFactory1317;
import net.sourceforge.plantuml.project2.PSystemProjectFactory2_1317;
import net.sourceforge.plantuml.salt.PSystemSaltFactory1317;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory1317;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory1317;
import net.sourceforge.plantuml.sudoku.PSystemSudokuFactory1317;
import net.sourceforge.plantuml.turing.PSystemTuringFactory1317;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemLicenseFactory1317;
import net.sourceforge.plantuml.version.PSystemVersionFactory1317;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemBuilder1317 {
    public final Diagram createPSystem(List<? extends CharSequence> list) {
        List<PSystemFactory1317> list2 = this.getAllFactories();
        DiagramType diagramType = DiagramType.getTypeFromArobaseStart(((Object)list.get(0)).toString());
        UmlSource umlSource = new UmlSource(list, diagramType == DiagramType.UML);
        DiagramType diagramType2 = umlSource.getDiagramType();
        ArrayList<PSystemError> arrayList = new ArrayList<PSystemError>();
        for (PSystemFactory1317 pSystemFactory1317 : list2) {
            if (diagramType2 != pSystemFactory1317.getDiagramType()) continue;
            Diagram diagram = pSystemFactory1317.createSystem(umlSource);
            if (this.isOk(diagram)) {
                return diagram;
            }
            arrayList.add((PSystemError)diagram);
        }
        PSystemError pSystemError = this.merge(arrayList);
        if (!OptionFlags.getInstance().isQuiet()) {
            pSystemError.print(System.err);
        }
        return pSystemError;
    }

    private List<PSystemFactory1317> getAllFactories() {
        ArrayList<PSystemFactory1317> arrayList = new ArrayList<PSystemFactory1317>();
        arrayList.add(new SequenceDiagramFactory1317());
        arrayList.add(new ClassDiagramFactory1317());
        arrayList.add(new ActivityDiagramFactory1317());
        arrayList.add(new DescriptionDiagramFactory1317());
        arrayList.add(new StateDiagramFactory1317());
        arrayList.add(new ActivityDiagramFactory3_1317());
        arrayList.add(new CompositeDiagramFactory1317());
        arrayList.add(new ObjectDiagramFactory1317());
        arrayList.add(new PostIdDiagramFactory1317());
        arrayList.add(new PrintSkinFactory1317());
        arrayList.add(new PSystemLicenseFactory1317());
        arrayList.add(new PSystemVersionFactory1317());
        arrayList.add(new PSystemDonorsFactory1317());
        arrayList.add(new PSystemListFontsFactory1317());
        arrayList.add(new PSystemSaltFactory1317(DiagramType.SALT));
        arrayList.add(new PSystemSaltFactory1317(DiagramType.UML));
        arrayList.add(new PSystemDotFactory1317(DiagramType.DOT));
        arrayList.add(new PSystemDotFactory1317(DiagramType.UML));
        if (License.getCurrent() == License.GPL) {
            arrayList.add(new PSystemDitaaFactory1317(DiagramType.DITAA));
            arrayList.add(new PSystemDitaaFactory1317(DiagramType.UML));
            arrayList.add(new PSystemJcckitFactory1317(DiagramType.JCCKIT));
            arrayList.add(new PSystemJcckitFactory1317(DiagramType.UML));
            arrayList.add(new PSystemLogoFactory1317());
            arrayList.add(new PSystemSudokuFactory1317());
            arrayList.add(new PSystemTuringFactory1317());
        }
        arrayList.add(new PSystemEggFactory1317());
        arrayList.add(new PSystemAppleTwoFactory1317());
        arrayList.add(new PSystemRIPFactory1317());
        arrayList.add(new PSystemLostFactory1317());
        arrayList.add(new PSystemPathFactory1317());
        arrayList.add(new PSystemOregonFactory1317());
        if (License.getCurrent() == License.GPL) {
            arrayList.add(new PSystemXearthFactory1317());
        }
        arrayList.add(new PSystemProjectFactory2_1317());
        arrayList.add(new FlowDiagramFactory1317());
        return arrayList;
    }

    private PSystemError merge(Collection<PSystemError> collection) {
        UmlSource umlSource = null;
        ArrayList<ErrorUml> arrayList = new ArrayList<ErrorUml>();
        for (PSystemError pSystemError : collection) {
            if (pSystemError.getSource() != null && umlSource == null) {
                umlSource = pSystemError.getSource();
            }
            arrayList.addAll(pSystemError.getErrorsUml());
        }
        if (umlSource == null) {
            throw new IllegalStateException();
        }
        return new PSystemError(umlSource, arrayList);
    }

    private boolean isOk(Diagram diagram) {
        return diagram != null && !(diagram instanceof PSystemError);
    }
}

