/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.NewpagedDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemUtils {
    public static List<File> exportDiagrams(Diagram diagram, File file, FileFormatOption fileFormatOption) throws IOException {
        if (diagram instanceof NewpagedDiagram) {
            return PSystemUtils.exportDiagramsNewpaged((NewpagedDiagram)diagram, file, fileFormatOption);
        }
        if (diagram instanceof SequenceDiagram) {
            return PSystemUtils.exportDiagramsSequence((SequenceDiagram)diagram, file, fileFormatOption);
        }
        if (diagram instanceof CucaDiagram) {
            return PSystemUtils.exportDiagramsCuca((CucaDiagram)diagram, file, fileFormatOption);
        }
        return PSystemUtils.exportDiagramsDefault(diagram, file, fileFormatOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsNewpaged(NewpagedDiagram newpagedDiagram, File file, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = newpagedDiagram.getNbImages();
        for (int i = 0; i < n; ++i) {
            File file2 = fileFormatOption.getFileFormat().computeFilename(file, i);
            Log.info("Creating file: " + file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                newpagedDiagram.exportDiagram(bufferedOutputStream, i, fileFormatOption);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
            Log.info("File size : " + file2.length());
            arrayList.add(file2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsDefault(Diagram diagram, File file, FileFormatOption fileFormatOption) throws IOException {
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + file);
        }
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            diagram.exportDiagram(outputStream, 0, fileFormatOption);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return Arrays.asList(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsSequence(SequenceDiagram sequenceDiagram, File file, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = sequenceDiagram.getNbImages();
        for (int i = 0; i < n; ++i) {
            File file2 = fileFormatOption.getFileFormat().computeFilename(file, i);
            Log.info("Creating file: " + file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            ImageData imageData = null;
            try {
                imageData = sequenceDiagram.exportDiagram(bufferedOutputStream, i, fileFormatOption);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
            if (sequenceDiagram.hasUrl() && imageData != null && imageData.containsCMapData()) {
                sequenceDiagram.exportCmap(file, imageData);
            }
            Log.info("File size : " + file2.length());
            arrayList.add(file2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> exportDiagramsCuca(CucaDiagram cucaDiagram, File file, FileFormatOption fileFormatOption) throws IOException {
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + file);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.HTML) {
            return PSystemUtils.createFilesHtml(cucaDiagram, file);
        }
        ImageData imageData = null;
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            imageData = cucaDiagram.exportDiagram(outputStream, 0, fileFormatOption);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        List<File> list = Arrays.asList(file);
        if (cucaDiagram.hasUrl() && imageData != null && imageData.containsCMapData()) {
            cucaDiagram.exportCmap(file, imageData);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PNG) {
            list = new PngSplitter(file, cucaDiagram.getHorizontalPages(), cucaDiagram.getVerticalPages(), cucaDiagram.getMetadata(), cucaDiagram.getDpi(fileFormatOption)).getFiles();
        }
        return list;
    }

    private static List<File> createFilesHtml(CucaDiagram cucaDiagram, File file) throws IOException {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        File file2 = new File(file.getParentFile(), string.substring(0, n));
        CucaDiagramHtmlMaker cucaDiagramHtmlMaker = new CucaDiagramHtmlMaker(cucaDiagram, file2);
        return cucaDiagramHtmlMaker.create();
    }
}

