/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.preproc.Defines;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceStringReader {
    private final List<BlockUml> blocks;

    public SourceStringReader(String string) {
        this(new Defines(), string, Collections.emptyList());
    }

    public SourceStringReader(String string, String string2) {
        this(new Defines(), string, "UTF-8", Collections.emptyList());
    }

    public SourceStringReader(Defines defines, String string, List<String> list) {
        this(defines, string, "UTF-8", list);
    }

    public SourceStringReader(Defines defines, String string, String string2, List<String> list) {
        try {
            BlockUmlBuilder blockUmlBuilder = new BlockUmlBuilder(list, string2, defines, new StringReader(string), null);
            this.blocks = blockUmlBuilder.getBlockUmls();
        }
        catch (IOException iOException) {
            Log.error("error " + iOException);
            throw new IllegalStateException(iOException);
        }
    }

    public String generateImage(OutputStream outputStream) throws IOException {
        return this.generateImage(outputStream, 0);
    }

    public String generateImage(File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        String string = this.generateImage((OutputStream)bufferedOutputStream, 0);
        ((OutputStream)bufferedOutputStream).close();
        return string;
    }

    public String generateImage(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        return this.generateImage(outputStream, 0, fileFormatOption);
    }

    public String generateImage(OutputStream outputStream, int n) throws IOException {
        return this.generateImage(outputStream, n, new FileFormatOption(FileFormat.PNG));
    }

    public String generateImage(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            GraphicStrings graphicStrings = new GraphicStrings(Arrays.asList("No @startuml found"));
            graphicStrings.writeImage(outputStream, fileFormatOption);
            return null;
        }
        for (BlockUml blockUml : this.blocks) {
            Diagram diagram = blockUml.getSystem();
            int n2 = diagram.getNbImages();
            if (n < n2) {
                ImageData imageData = diagram.exportDiagram(outputStream, n, fileFormatOption);
                if (imageData.containsCMapData()) {
                    return diagram.getDescription() + "\n" + imageData.getCMapData("plantuml");
                }
                return diagram.getDescription();
            }
            n -= n2;
        }
        Log.error("numImage is too big = " + n);
        return null;
    }

    public final List<BlockUml> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }
}

