/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkActivity2
extends SingleLineCommand2<ActivityDiagram> {
    public CommandLinkActivity2() {
        super(CommandLinkActivity2.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOptional((IRegex)new RegexOr("FIRST", new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([\\p{L}0-9][\\p{L}0-9_.]*)"), new RegexLeaf("BAR", "(?:==+)\\s*([\\p{L}0-9_.]+)\\s*(?:==+)"), new RegexLeaf("QUOTED", "\"([^\"]+)\"(?:\\s+as\\s+([\\p{L}0-9_.]+))?"))), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("BACKCOLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("\\s*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("ARROW_BODY1", "([-.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(\\*|left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-.]*)\\>"), new RegexLeaf("\\s*"), new RegexLeaf("BRACKET", "(?:\\[([^\\]*]+[^\\]]*)\\])?"), new RegexLeaf("\\s*"), new RegexOr("FIRST2", new RegexLeaf("STAR2", "(\\(\\*(top)?\\))"), new RegexLeaf("OPENBRACKET2", "(\\{)"), new RegexLeaf("CODE2", "([\\p{L}0-9][\\p{L}0-9_.]*)"), new RegexLeaf("BAR2", "(?:==+)\\s*([\\p{L}0-9_.]+)\\s*(?:==+)"), new RegexLeaf("QUOTED2", "\"([^\"]+)\"(?:\\s+as\\s+([\\p{L}0-9][\\p{L}0-9_.]*))?"), new RegexLeaf("QUOTED_INVISIBLE2", "(\\w.*?)")), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE2", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("PARTITION2", "(?:in\\s+(\"[^\"]+\"|\\S+))?"), new RegexLeaf("\\s*"), new RegexLeaf("BACKCOLOR2", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram activityDiagram, RegexResult regexResult) {
        Direction direction;
        IEntity iEntity;
        IEntity iEntity2 = CommandLinkActivity2.getEntity(activityDiagram, regexResult, true);
        if (iEntity2 == null) {
            return CommandExecutionResult.error("No such activity");
        }
        if (regexResult.get("STEREOTYPE", 0) != null) {
            iEntity2.setStereotype(new Stereotype(regexResult.get("STEREOTYPE", 0)));
        }
        if (regexResult.get("BACKCOLOR", 0) != null) {
            iEntity2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("BACKCOLOR", 0)));
        }
        if ((iEntity = CommandLinkActivity2.getEntity(activityDiagram, regexResult, false)) == null) {
            return CommandExecutionResult.error("No such activity");
        }
        if (regexResult.get("BACKCOLOR2", 0) != null) {
            iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("BACKCOLOR2", 0)));
        }
        if (regexResult.get("STEREOTYPE2", 0) != null) {
            iEntity.setStereotype(new Stereotype(regexResult.get("STEREOTYPE2", 0)));
        }
        Display display = Display.getWithNewlines(regexResult.get("BRACKET", 0));
        String string = CommandLinkClass.notNull(regexResult.get("ARROW_BODY1", 0));
        String string2 = CommandLinkClass.notNull(regexResult.get("ARROW_BODY2", 0));
        String string3 = CommandLinkClass.notNull(regexResult.get("ARROW_DIRECTION", 0));
        String string4 = StringUtils.manageArrowForCuca(string + string3 + string2 + ">");
        int n = string4.length() - 1;
        if (string3.contains("*")) {
            n = 2;
        }
        LinkType linkType = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        if ((string + string2).contains(".")) {
            linkType = linkType.getDotted();
        }
        Link link = new Link(iEntity2, iEntity, linkType, display, n);
        if (string3.contains("*")) {
            link.setConstraint(false);
        }
        if ((direction = StringUtils.getArrowDirection(string + string3 + string2 + ">")) == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        if (regexResult.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(activityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(regexResult.get("URL", 0));
            link.setUrl(url);
        }
        CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), link);
        activityDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    static IEntity getEntity(ActivityDiagram activityDiagram, RegexResult regexResult, boolean bl) {
        Code code;
        String string = bl ? "" : "2";
        String string2 = regexResult.get("OPENBRACKET" + string, 0);
        if (string2 != null) {
            return activityDiagram.createInnerActivity();
        }
        if (regexResult.get("STAR" + string, 0) != null) {
            if (bl) {
                if (regexResult.get("STAR" + string, 1) != null) {
                    activityDiagram.getStart().setTop(true);
                }
                return activityDiagram.getStart();
            }
            return activityDiagram.getEnd();
        }
        String string3 = regexResult.get("PARTITION" + string, 0);
        if (string3 != null) {
            string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3);
        }
        if ((code = Code.of(regexResult.get("CODE" + string, 0))) != null) {
            if (string3 != null) {
                activityDiagram.getOrCreateGroup(Code.of(string3), Display.getWithNewlines(string3), null, GroupType.PACKAGE, activityDiagram.getRootGroup());
            }
            IEntity iEntity = activityDiagram.getOrCreate(code, Display.getWithNewlines(code), CommandLinkActivity2.getTypeIfExisting(activityDiagram, code));
            if (string3 != null) {
                activityDiagram.endGroup();
            }
            return iEntity;
        }
        String string4 = regexResult.get("BAR" + string, 0);
        if (string4 != null) {
            return activityDiagram.getOrCreate(Code.of(string4), Display.getWithNewlines(string4), LeafType.SYNCHRO_BAR);
        }
        RegexPartialMatch regexPartialMatch = regexResult.get("QUOTED" + string);
        if (regexPartialMatch.get(0) != null) {
            Code code2 = Code.of(regexPartialMatch.get(1) == null ? regexPartialMatch.get(0) : regexPartialMatch.get(1));
            if (string3 != null) {
                activityDiagram.getOrCreateGroup(Code.of(string3), Display.getWithNewlines(string3), null, GroupType.PACKAGE, activityDiagram.getRootGroup());
            }
            IEntity iEntity = activityDiagram.getOrCreate(code2, Display.getWithNewlines(regexPartialMatch.get(0)), CommandLinkActivity2.getTypeIfExisting(activityDiagram, code2));
            if (string3 != null) {
                activityDiagram.endGroup();
            }
            return iEntity;
        }
        Code code3 = Code.of(regexResult.get("QUOTED_INVISIBLE" + string, 0));
        if (code3 != null) {
            if (string3 != null) {
                activityDiagram.getOrCreateGroup(Code.of(string3), Display.getWithNewlines(string3), null, GroupType.PACKAGE, activityDiagram.getRootGroup());
            }
            IEntity iEntity = activityDiagram.getOrCreate(code3, Display.getWithNewlines(code3), LeafType.ACTIVITY);
            if (string3 != null) {
                activityDiagram.endGroup();
            }
            return iEntity;
        }
        String string5 = regexResult.get("FIRST" + string, 0);
        if (string5 == null) {
            return activityDiagram.getLastEntityConsulted();
        }
        return null;
    }

    static LeafType getTypeIfExisting(ActivityDiagram activityDiagram, Code code) {
        IEntity iEntity;
        if (activityDiagram.leafExist(code) && (iEntity = (IEntity)activityDiagram.getLeafs().get(code)).getEntityType() == LeafType.BRANCH) {
            return LeafType.BRANCH;
        }
        return LeafType.ACTIVITY;
    }

    static LeafType getTypeFromString(String string, LeafType leafType) {
        if (string == null) {
            return LeafType.ACTIVITY;
        }
        if (string.equals("*")) {
            return leafType;
        }
        if (string.startsWith("=")) {
            return LeafType.SYNCHRO_BAR;
        }
        throw new IllegalArgumentException();
    }
}

