/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionSimple
implements Instruction {
    private final Display label;
    private final HtmlColor color;
    private final LinkRendering inlinkRendering;
    private Display note;
    private NotePosition notePosition;
    private final Swimlane swimlane;

    public InstructionSimple(Display display, HtmlColor htmlColor, LinkRendering linkRendering, Swimlane swimlane) {
        this.label = display;
        this.color = htmlColor;
        this.inlinkRendering = linkRendering;
        this.swimlane = swimlane;
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        Ftile ftile = ftileFactory.activity(this.label, this.color, this.swimlane);
        if (this.note == null) {
            return ftile;
        }
        return ftileFactory.addNote(ftile, this.note, this.notePosition);
    }

    @Override
    public void add(Instruction instruction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        return false;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public void addNote(Display display, NotePosition notePosition) {
        this.note = display;
        this.notePosition = notePosition;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.swimlane == null ? Collections.emptySet() : Collections.singleton(this.swimlane);
    }
}

