/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImageNote2
implements TextBlock {
    private final int cornersize = 10;
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final boolean withShadow;
    private final TextBlock textBlock;

    public EntityImageNote2(Display display) {
        SkinParam skinParam = new SkinParam(UmlDiagramType.ACTIVITY);
        this.withShadow = skinParam.shadowing();
        Rose rose = new Rose();
        this.noteBackgroundColor = rose.getHtmlColor(skinParam, ColorParam.noteBackground);
        this.borderColor = rose.getHtmlColor(skinParam, ColorParam.noteBorder);
        HtmlColor htmlColor = rose.getFontColor(skinParam, FontParam.NOTE);
        UFont uFont = skinParam.getFont(FontParam.NOTE, null);
        this.textBlock = TextBlockUtils.create(display, new FontConfiguration(uFont, htmlColor), HorizontalAlignment.LEFT, skinParam);
    }

    private double getTextHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return dimension2D.getHeight() + 10.0;
    }

    private double getPureTextWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return dimension2D.getWidth();
    }

    private double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 6.0 + 15.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getTextHeight(stringBounder);
        double d2 = this.getTextWidth(stringBounder);
        return new Dimension2DDouble(d2 + 1.0, d + 1.0);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        UPolygon uPolygon = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            uPolygon.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(this.noteBackgroundColor)).apply(new UChangeColor(this.borderColor));
        uGraphic.draw(uPolygon);
        uGraphic.apply(new UTranslate(this.getTextWidth(stringBounder) - 10.0, 0.0)).draw(new ULine(0.0, 10.0));
        uGraphic.apply(new UTranslate(this.getTextWidth(stringBounder), 10.0)).draw(new ULine(-10.0, 0.0));
        this.textBlock.drawU(uGraphic.apply(new UTranslate(6.0, 5.0)));
    }

    private UPolygon getPolygonNormal(StringBounder stringBounder) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getTextHeight(stringBounder));
        double d = this.getTextWidth(stringBounder);
        uPolygon.addPoint(d, this.getTextHeight(stringBounder));
        uPolygon.addPoint(d, 10.0);
        uPolygon.addPoint(d - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

