/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ConnectionVerticalDown
extends AbstractConnection {
    private final Point2D p1;
    private final Point2D p2;
    private final HtmlColor color;

    public ConnectionVerticalDown(Ftile ftile, Ftile ftile2, Point2D point2D, Point2D point2D2, HtmlColor htmlColor) {
        super(ftile, ftile2);
        this.p1 = point2D;
        this.p2 = point2D2;
        this.color = htmlColor;
    }

    public void drawU(UGraphic uGraphic) {
        Snake snake = new Snake(this.color, Arrows.asToDown());
        snake.addPoint(this.p1);
        snake.addPoint(this.p2);
        snake.drawU(uGraphic);
    }

    public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
        Snake snake = new Snake(this.color, Arrows.asToDown());
        Point2D point2D = uTranslate.getTranslated(this.p1);
        Point2D point2D2 = uTranslate2.getTranslated(this.p2);
        double d = (point2D.getY() + point2D2.getY()) / 2.0;
        snake.addPoint(point2D);
        snake.addPoint(point2D.getX(), d);
        snake.addPoint(point2D2.getX(), d);
        snake.addPoint(point2D2);
        snake.drawU(uGraphic);
    }
}

