/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixed;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBlackBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileFactoryDelegatorCreateFork2
extends FtileFactoryDelegator {
    private final double spaceArroundBlackBar = 20.0;
    private final double barHeight = 6.0;
    private final double xMargin = 14.0;
    private final Rose rose = new Rose();

    public FtileFactoryDelegatorCreateFork2(FtileFactory ftileFactory, ISkinParam iSkinParam) {
        super(ftileFactory, iSkinParam);
    }

    @Override
    public Ftile createFork(List<Ftile> list) {
        Ftile ftile3;
        HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityBar);
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
        Dimension2D dimension2D = super.createFork(list).asTextBlock().calculateDimension(this.getStringBounder());
        double d = dimension2D.getHeight() + 40.0;
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Ftile object2 : list) {
            arrayList.add(new FtileHeightFixed(new FtileMarged(object2, 14.0), d));
        }
        Ftile ftile2 = super.createFork(arrayList);
        ArrayList<Connection> arrayList2 = new ArrayList<Connection>();
        ArrayList<ConnectionOut> arrayList3 = new ArrayList<ConnectionOut>();
        double d2 = 0.0;
        for (Ftile ftile3 : arrayList) {
            Dimension2D dimension2D2 = ftile3.asTextBlock().calculateDimension(this.getStringBounder());
            arrayList2.add(new ConnectionIn(ftile3, d2, htmlColor2, 6.0));
            arrayList3.add(new ConnectionOut(ftile3, d2, htmlColor2, d));
            d2 += dimension2D2.getWidth();
        }
        Object object = new FtileBlackBlock(this.shadowing(), ftile2.asTextBlock().calculateDimension(this.getStringBounder()).getWidth(), 6.0, htmlColor, ((Ftile)arrayList.get(0)).getSwimlaneIn());
        object = FtileUtils.addConnection((Ftile)object, arrayList2);
        ftile3 = new FtileBlackBlock(this.shadowing(), ftile2.asTextBlock().calculateDimension(this.getStringBounder()).getWidth(), 6.0, htmlColor, ((Ftile)arrayList.get(0)).getSwimlaneIn());
        return new FtileAssemblySimple(new FtileAssemblySimple((Ftile)object, ftile2), ftile3);
    }

    class ConnectionOut
    extends AbstractConnection {
        private final double x;
        private final HtmlColor arrowColor;
        private final double height;

        public ConnectionOut(Ftile ftile, double d, HtmlColor htmlColor, double d2) {
            super(ftile, null);
            this.x = d;
            this.arrowColor = htmlColor;
            this.height = d2;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            Point2D point2D = this.getFtile1().getPointOut(FtileFactoryDelegatorCreateFork2.this.getStringBounder());
            if (point2D == null) {
                return;
            }
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D.getX(), point2D.getY());
            snake.addPoint(point2D.getX(), this.height);
            snake.drawU(uGraphic);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final double x;
        private final HtmlColor arrowColor;
        private final double barHeight;

        public ConnectionIn(Ftile ftile, double d, HtmlColor htmlColor, double d2) {
            super(null, ftile);
            this.x = d;
            this.arrowColor = htmlColor;
            this.barHeight = d2;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, this.barHeight));
            Point2D point2D = this.getFtile2().getPointIn(FtileFactoryDelegatorCreateFork2.this.getStringBounder());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D.getX(), 0.0);
            snake.addPoint(point2D.getX(), point2D.getY());
            snake.drawU(uGraphic);
        }
    }
}

