/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileWithNoteOpale
extends AbstractFtile {
    private final Ftile tile;
    private final Opale opale;
    private final HtmlColor arrowColor;
    private final NotePosition notePosition;
    private final double halfSuppSpace = 20.0;

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    public FtileWithNoteOpale(Ftile ftile, Display display, HtmlColor htmlColor, NotePosition notePosition) {
        super(ftile.shadowing());
        this.tile = ftile;
        this.notePosition = notePosition;
        this.arrowColor = htmlColor;
        SkinParam skinParam = new SkinParam(UmlDiagramType.ACTIVITY);
        if (!this.shadowing()) {
            skinParam.setParam("shadowing", "false");
        }
        Rose rose = new Rose();
        HtmlColor htmlColor2 = rose.getFontColor(skinParam, FontParam.NOTE);
        UFont uFont = skinParam.getFont(FontParam.NOTE, null);
        HtmlColor htmlColor3 = rose.getHtmlColor(skinParam, ColorParam.noteBackground);
        HtmlColor htmlColor4 = rose.getHtmlColor(skinParam, ColorParam.noteBorder);
        TextBlock textBlock = TextBlockUtils.create(display, new FontConfiguration(uFont, htmlColor2), HorizontalAlignment.LEFT, skinParam);
        this.opale = new Opale(htmlColor4, htmlColor3, textBlock, skinParam.shadowing());
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        return this.getTranslate(stringBounder).getTranslated(this.tile.getPointIn(stringBounder));
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        return this.getTranslate(stringBounder).getTranslated(this.tile.getPointOut(stringBounder));
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimension2D2 = this.opale.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.tile.asTextBlock().calculateDimension(stringBounder);
        double d = (dimension2D.getHeight() - dimension2D3.getHeight()) / 2.0;
        double d2 = dimension2D2.getWidth() + 20.0;
        return new UTranslate(d2, d);
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                Dimension2D dimension2D = this.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = FtileWithNoteOpale.this.opale.calculateDimension(stringBounder);
                Dimension2D dimension2D3 = FtileWithNoteOpale.this.tile.asTextBlock().calculateDimension(stringBounder);
                double d = (dimension2D.getHeight() - dimension2D2.getHeight()) / 2.0;
                double d2 = (dimension2D.getHeight() - dimension2D3.getHeight()) / 2.0;
                double d3 = dimension2D2.getWidth() + 20.0;
                if (FtileWithNoteOpale.this.notePosition == NotePosition.LEFT) {
                    Direction direction = Direction.RIGHT;
                    Point2D.Double double_ = new Point2D.Double(dimension2D2.getWidth(), dimension2D2.getHeight() / 2.0);
                    Point2D.Double double_2 = new Point2D.Double(d3, dimension2D2.getHeight() / 2.0);
                    FtileWithNoteOpale.this.opale.setOpale(direction, double_, double_2);
                    FtileWithNoteOpale.this.opale.drawU(uGraphic.apply(new UTranslate(0.0, d)));
                } else {
                    double d4 = dimension2D.getWidth() - dimension2D2.getWidth();
                    Direction direction = Direction.LEFT;
                    Point2D.Double double_ = new Point2D.Double(0.0, dimension2D2.getHeight() / 2.0);
                    Point2D.Double double_3 = new Point2D.Double(-20.0, dimension2D2.getHeight() / 2.0);
                    FtileWithNoteOpale.this.opale.setOpale(direction, double_, double_3);
                    FtileWithNoteOpale.this.opale.drawU(uGraphic.apply(new UTranslate(d4, d)));
                }
                uGraphic.apply(FtileWithNoteOpale.this.getTranslate(stringBounder)).draw(FtileWithNoteOpale.this.tile);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return FtileWithNoteOpale.this.calculateDimensionInternal(stringBounder);
            }

            @Override
            public List<Url> getUrls() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isKilled() {
        return this.tile.isKilled();
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.opale.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.tile.asTextBlock().calculateDimension(stringBounder);
        double d = Math.max(dimension2D.getHeight(), dimension2D2.getHeight());
        return new Dimension2DDouble(dimension2D2.getWidth() + 2.0 * dimension2D.getWidth() + 40.0, d);
    }
}

