/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UGraphicInterceptorOneSwimlane
implements UGraphic {
    private final UGraphic ug;
    private final Swimlane swimlane;

    public UGraphicInterceptorOneSwimlane(UGraphic uGraphic, Swimlane swimlane) {
        this.ug = uGraphic;
        this.swimlane = swimlane;
    }

    public StringBounder getStringBounder() {
        return this.ug.getStringBounder();
    }

    public UParam getParam() {
        return this.ug.getParam();
    }

    public void draw(UShape uShape) {
        if (uShape instanceof Ftile) {
            Ftile ftile = (Ftile)uShape;
            Set<Swimlane> set = ftile.getSwimlanes();
            boolean bl = set.contains(this.swimlane);
            if (bl) {
                ftile.asTextBlock().drawU(this);
            }
        } else if (uShape instanceof Connection) {
            boolean bl;
            Connection connection = (Connection)uShape;
            Ftile ftile = connection.getFtile1();
            Ftile ftile2 = connection.getFtile2();
            boolean bl2 = ftile == null || ftile.getSwimlaneOut() == null || ftile.getSwimlaneOut() == this.swimlane;
            boolean bl3 = bl = ftile2 == null || ftile2.getSwimlaneIn() == null || ftile2.getSwimlaneIn() == this.swimlane;
            if (bl2 && bl) {
                connection.drawU(this);
            }
        } else {
            this.ug.draw(uShape);
        }
    }

    public UGraphic apply(UChange uChange) {
        return new UGraphicInterceptorOneSwimlane(this.ug.apply(uChange), this.swimlane);
    }

    public ColorMapper getColorMapper() {
        return this.ug.getColorMapper();
    }

    public void startUrl(Url url) {
        this.ug.startUrl(url);
    }

    public void closeAction() {
        this.ug.closeAction();
    }

    public void writeImage(OutputStream outputStream, String string, int n) throws IOException {
        this.ug.writeImage(outputStream, string, n);
    }
}

