/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileBlackBlock
extends AbstractFtile {
    private final double width;
    private final double height;
    private final HtmlColor colorBar;
    private final Swimlane swimlane;

    public FtileBlackBlock(boolean bl, double d, double d2, HtmlColor htmlColor, Swimlane swimlane) {
        super(bl);
        this.height = d2;
        this.width = d;
        this.colorBar = htmlColor;
        this.swimlane = swimlane;
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        return new Point2D.Double(this.width / 2.0, 0.0);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        return new Point2D.Double(this.width / 2.0, this.height);
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                URectangle uRectangle = new URectangle(FtileBlackBlock.this.width, FtileBlackBlock.this.height, 5.0, 5.0);
                if (FtileBlackBlock.this.shadowing()) {
                    uRectangle.setDeltaShadow(3.0);
                }
                uGraphic.apply(new UChangeColor(FtileBlackBlock.this.colorBar)).apply(new UChangeBackColor(FtileBlackBlock.this.colorBar)).draw(uRectangle);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(FtileBlackBlock.this.width, FtileBlackBlock.this.height);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    public boolean isKilled() {
        return false;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }
}

