/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandAddMethod;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClass;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.classdiagram.command.CommandDiamondAssociation;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShow;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShow3;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShow4;
import net.sourceforge.plantuml.classdiagram.command.CommandImport;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkLollipop;
import net.sourceforge.plantuml.classdiagram.command.CommandMouseOver;
import net.sourceforge.plantuml.classdiagram.command.CommandNamespaceSeparator;
import net.sourceforge.plantuml.classdiagram.command.CommandStereotype;
import net.sourceforge.plantuml.classdiagram.command.CommandUrl;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandEndNamespace;
import net.sourceforge.plantuml.command.CommandEndPackage;
import net.sourceforge.plantuml.command.CommandNamespace;
import net.sourceforge.plantuml.command.CommandPackage;
import net.sourceforge.plantuml.command.CommandPackageEmpty;
import net.sourceforge.plantuml.command.CommandPage;
import net.sourceforge.plantuml.command.CommandRankDir;
import net.sourceforge.plantuml.command.UmlDiagramFactory1317;
import net.sourceforge.plantuml.command.note.FactoryNoteCommand;
import net.sourceforge.plantuml.command.note.FactoryNoteOnEntityCommand;
import net.sourceforge.plantuml.command.note.FactoryNoteOnLinkCommand;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDiagramFactory1317
extends UmlDiagramFactory1317 {
    @Override
    public ClassDiagram createEmptyDiagram() {
        return new ClassDiagram();
    }

    @Override
    protected List<Command> createCommands() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addCommonCommands(arrayList);
        arrayList.add(new CommandRankDir());
        arrayList.add(new CommandPage());
        arrayList.add(new CommandAddMethod());
        arrayList.add(new CommandCreateClass());
        FactoryNoteCommand factoryNoteCommand = new FactoryNoteCommand();
        arrayList.add(factoryNoteCommand.createSingleLine());
        arrayList.add(new CommandPackage());
        arrayList.add(new CommandEndPackage());
        arrayList.add(new CommandPackageEmpty());
        arrayList.add(new CommandNamespace());
        arrayList.add(new CommandEndNamespace());
        arrayList.add(new CommandStereotype());
        arrayList.add(new CommandLinkClass(UmlDiagramType.CLASS));
        arrayList.add(new CommandLinkLollipop(UmlDiagramType.CLASS));
        arrayList.add(new CommandImport());
        FactoryNoteOnEntityCommand factoryNoteOnEntityCommand = new FactoryNoteOnEntityCommand(new RegexLeaf("ENTITY", "([^\\s{}\"<>]+|\"[^\"]+\")"));
        arrayList.add(factoryNoteOnEntityCommand.createSingleLine());
        arrayList.add(new CommandUrl());
        arrayList.add(factoryNoteOnEntityCommand.createMultiLine());
        arrayList.add(factoryNoteCommand.createMultiLine());
        arrayList.add(new CommandCreateClassMultilines());
        FactoryNoteOnLinkCommand factoryNoteOnLinkCommand = new FactoryNoteOnLinkCommand();
        arrayList.add(factoryNoteOnLinkCommand.createSingleLine());
        arrayList.add(factoryNoteOnLinkCommand.createMultiLine());
        arrayList.add(new CommandDiamondAssociation());
        arrayList.add(new CommandMouseOver());
        arrayList.add(new CommandHideShow3());
        arrayList.add(new CommandHideShow());
        arrayList.add(new CommandHideShow4());
        arrayList.add(new CommandNamespaceSeparator());
        return arrayList;
    }

    @Override
    public String checkFinalError(AbstractPSystem abstractPSystem) {
        ClassDiagram classDiagram = (ClassDiagram)abstractPSystem;
        for (Link removeable : classDiagram.getLinks()) {
            int n = removeable.getLength();
            if (n != 1) continue;
            for (Link link : classDiagram.getLinks()) {
                if (!link.sameConnections(removeable) || link.getLength() == 1) continue;
                link.setLength(1);
            }
        }
        for (IGroup iGroup : classDiagram.getGroups(true)) {
            ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
            for (ILeaf iLeaf : iGroup.getLeafsDirect()) {
                if (!classDiagram.isStandalone(iLeaf)) continue;
                arrayList.add(iLeaf);
            }
            if (arrayList.size() < 3) continue;
            this.putInSquare(classDiagram, arrayList);
        }
        return super.checkFinalError(classDiagram);
    }

    private void putInSquare(ClassDiagram classDiagram, List<ILeaf> list) {
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();
        int n = ClassDiagramFactory1317.computeBranch(list.size());
        int n2 = 0;
        for (int i = 1; i < list.size(); ++i) {
            Link link;
            IEntity iEntity;
            int n3 = i - n2;
            IEntity iEntity2 = list.get(i);
            if (n3 == n) {
                iEntity = list.get(n2);
                link = new Link(iEntity, iEntity2, linkType, null, 2);
                n2 = i;
            } else {
                iEntity = list.get(i - 1);
                link = new Link(iEntity, iEntity2, linkType, null, 1);
            }
            classDiagram.addLink(link);
        }
    }

    static int computeBranch(int n) {
        double d = Math.sqrt(n);
        int n2 = (int)d;
        if (n2 * n2 == n) {
            return n2;
        }
        return n2 + 1;
    }
}

