/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHideShow4
extends SingleLineCommand2<ClassDiagram> {
    public CommandHideShow4() {
        super(CommandHideShow4.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("\\s+"), new RegexLeaf("CODE", "([^\\s{}\"<>]+)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult regexResult) {
        Code code = Code.of(regexResult.get("CODE", 0));
        ILeaf iLeaf = classDiagram.getEntityFactory().getLeafs().get(code);
        if (iLeaf == null) {
            return CommandExecutionResult.error("Class does not exit : " + code);
        }
        classDiagram.hideOrShow(iLeaf, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        return CommandExecutionResult.ok();
    }
}

