/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.StartUtils;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandComment;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandFooter;
import net.sourceforge.plantuml.command.CommandHeader;
import net.sourceforge.plantuml.command.CommandHideUnlinked;
import net.sourceforge.plantuml.command.CommandMinwidth;
import net.sourceforge.plantuml.command.CommandMultilinesComment;
import net.sourceforge.plantuml.command.CommandMultilinesFooter;
import net.sourceforge.plantuml.command.CommandMultilinesHeader;
import net.sourceforge.plantuml.command.CommandMultilinesLegend;
import net.sourceforge.plantuml.command.CommandMultilinesTitle;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.CommandPragma;
import net.sourceforge.plantuml.command.CommandRotate;
import net.sourceforge.plantuml.command.CommandScale;
import net.sourceforge.plantuml.command.CommandScaleWidthAndHeight;
import net.sourceforge.plantuml.command.CommandScaleWidthOrHeight;
import net.sourceforge.plantuml.command.CommandSkinParam;
import net.sourceforge.plantuml.command.CommandSkinParamMultilines;
import net.sourceforge.plantuml.command.CommandSpriteFile;
import net.sourceforge.plantuml.command.CommandTitle;
import net.sourceforge.plantuml.command.FactorySpriteCommand;
import net.sourceforge.plantuml.command.PSystemAbstractFactory1317;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.suggest.SuggestEngine1317;
import net.sourceforge.plantuml.suggest.SuggestEngineResult;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;
import net.sourceforge.plantuml.version.IteratorCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UmlDiagramFactory1317
extends PSystemAbstractFactory1317 {
    private final List<Command> cmds = this.createCommands();

    protected UmlDiagramFactory1317() {
        this(DiagramType.UML);
    }

    protected UmlDiagramFactory1317(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public final Diagram createSystem(UmlSource umlSource) {
        IteratorCounter iteratorCounter = umlSource.iterator();
        String string = (String)iteratorCounter.next();
        if (!StartUtils.isArobaseStartDiagram(string)) {
            throw new UnsupportedOperationException();
        }
        if (umlSource.isEmpty()) {
            return this.buildEmptyError(umlSource);
        }
        AbstractPSystem abstractPSystem = this.createEmptyDiagram();
        while (iteratorCounter.hasNext()) {
            String string2 = (String)iteratorCounter.next();
            if (StartUtils.isArobaseEndDiagram(string2)) {
                String string3 = this.checkFinalError(abstractPSystem);
                if (string3 != null) {
                    return this.buildEmptyError(umlSource, string3);
                }
                if (umlSource.getTotalLineCount() == 2) {
                    return this.buildEmptyError(umlSource);
                }
                if (abstractPSystem == null) {
                    return null;
                }
                abstractPSystem.makeDiagramReady();
                if (!abstractPSystem.isOk()) {
                    return null;
                }
                abstractPSystem.setSource(umlSource);
                return abstractPSystem;
            }
            if (!((abstractPSystem = this.executeOneLine(abstractPSystem, umlSource, iteratorCounter, string2)) instanceof PSystemError)) continue;
            return abstractPSystem;
        }
        abstractPSystem.setSource(umlSource);
        return abstractPSystem;
    }

    private AbstractPSystem executeOneLine(AbstractPSystem abstractPSystem, UmlSource umlSource, IteratorCounter iteratorCounter, String string) {
        CommandControl commandControl = this.isValid(Arrays.asList(string));
        if (commandControl == CommandControl.NOT_OK) {
            SuggestEngine1317 suggestEngine1317;
            SuggestEngineResult suggestEngineResult;
            ErrorUml errorUml = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", iteratorCounter.currentNum() - 1);
            if (OptionFlags.getInstance().isUseSuggestEngine() && (suggestEngineResult = (suggestEngine1317 = new SuggestEngine1317(umlSource, this)).tryToSuggest(abstractPSystem)).getStatus() == SuggestEngineStatus.ONE_SUGGESTION) {
                errorUml.setSuggest(suggestEngineResult);
            }
            abstractPSystem = new PSystemError(umlSource, errorUml);
        } else if (commandControl == CommandControl.OK_PARTIAL) {
            boolean bl = this.manageMultiline(abstractPSystem, string, iteratorCounter);
            if (!bl) {
                abstractPSystem = new PSystemError(umlSource, new ErrorUml(ErrorUmlType.EXECUTION_ERROR, "Syntax Error?", iteratorCounter.currentNum() - 1));
            }
        } else if (commandControl == CommandControl.OK) {
            Command command = this.createCommand(Arrays.asList(string));
            CommandExecutionResult commandExecutionResult = abstractPSystem.executeCommand(command, Arrays.asList(string));
            if (!commandExecutionResult.isOk()) {
                abstractPSystem = new PSystemError(umlSource, new ErrorUml(ErrorUmlType.EXECUTION_ERROR, commandExecutionResult.getError(), iteratorCounter.currentNum() - 1));
            }
            if (commandExecutionResult.getNewDiagram() != null) {
                abstractPSystem = commandExecutionResult.getNewDiagram();
            }
        } else assert (false);
        return abstractPSystem;
    }

    private boolean manageMultiline(AbstractPSystem abstractPSystem, String string, IteratorCounter iteratorCounter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        while (iteratorCounter.hasNext()) {
            String string2 = (String)iteratorCounter.next();
            if (StartUtils.isArobaseEndDiagram(string2)) {
                return false;
            }
            arrayList.add(string2);
            CommandControl commandControl = this.isValid(arrayList);
            if (commandControl == CommandControl.NOT_OK) {
                return false;
            }
            if (commandControl != CommandControl.OK) continue;
            Command command = this.createCommand(arrayList);
            CommandExecutionResult commandExecutionResult = abstractPSystem.executeCommand(command, arrayList);
            return commandExecutionResult.isOk();
        }
        return false;
    }

    public String checkFinalError(AbstractPSystem abstractPSystem) {
        return null;
    }

    public final CommandControl isValid(List<String> list) {
        for (Command command : this.cmds) {
            CommandControl commandControl = command.isValid(list);
            if (commandControl != CommandControl.OK && commandControl != CommandControl.OK_PARTIAL) continue;
            return commandControl;
        }
        return CommandControl.NOT_OK;
    }

    public final Command createCommand(List<String> list) {
        for (Command command : this.cmds) {
            CommandControl commandControl = command.isValid(list);
            if (commandControl == CommandControl.OK) {
                return command;
            }
            if (commandControl != CommandControl.OK_PARTIAL) continue;
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    protected abstract List<Command> createCommands();

    public abstract AbstractPSystem createEmptyDiagram();

    protected final void addCommonCommands(List<Command> list) {
        list.add(new CommandNope());
        list.add(new CommandComment());
        list.add(new CommandMultilinesComment());
        list.add(new CommandPragma());
        list.add(new CommandTitle());
        list.add(new CommandMultilinesTitle());
        list.add(new CommandMultilinesLegend());
        list.add(new CommandFooter());
        list.add(new CommandMultilinesFooter());
        list.add(new CommandHeader());
        list.add(new CommandMultilinesHeader());
        list.add(new CommandSkinParam());
        list.add(new CommandSkinParamMultilines());
        list.add(new CommandMinwidth());
        list.add(new CommandRotate());
        list.add(new CommandScale());
        list.add(new CommandScaleWidthAndHeight());
        list.add(new CommandScaleWidthOrHeight());
        list.add(new CommandHideUnlinked());
        FactorySpriteCommand factorySpriteCommand = new FactorySpriteCommand();
        list.add(factorySpriteCommand.createMultiLine());
        list.add(factorySpriteCommand.createSingleLine());
        list.add(new CommandSpriteFile());
    }

    public final List<String> getDescription() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Command command : this.createCommands()) {
            arrayList.addAll(Arrays.asList(command.getDescription()));
        }
        return Collections.unmodifiableList(arrayList);
    }
}

