/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StartUtils;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.version.IteratorCounter;
import net.sourceforge.plantuml.version.IteratorCounterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UmlSource {
    private final List<String> source;

    public UmlSource(List<? extends CharSequence> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (CharSequence charSequence : list) {
                String string = ((Object)charSequence).toString();
                if (string.endsWith("\\") && !string.endsWith("\\\\")) {
                    stringBuilder.append(string.substring(0, string.length() - 1));
                    continue;
                }
                stringBuilder.append(string);
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        } else {
            for (CharSequence charSequence : list) {
                arrayList.add(((Object)charSequence).toString());
            }
        }
        this.source = Collections.unmodifiableList(arrayList);
    }

    public DiagramType getDiagramType() {
        return DiagramType.getTypeFromArobaseStart(this.source.get(0));
    }

    public IteratorCounter iterator() {
        return new IteratorCounterImpl(this.source.iterator());
    }

    public String getPlainString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.source) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String getLine(int n) {
        return this.source.get(n);
    }

    public int getTotalLineCount() {
        return this.source.size();
    }

    public boolean isEmpty() {
        for (String string : this.source) {
            if (StartUtils.isArobaseStartDiagram(string) || StartUtils.isArobaseEndDiagram(string) || string.matches("\\s*'.*") || string.trim().length() == 0) continue;
            return false;
        }
        return true;
    }

    public Display getTitle() {
        Pattern pattern = Pattern.compile("(?i)^\\s*title\\s+(.+)$");
        for (String string : this.source) {
            Matcher matcher = pattern.matcher(string);
            boolean bl = matcher.matches();
            if (!bl) continue;
            return Display.asList(matcher.group(1));
        }
        return Display.emptyList();
    }
}

