/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.cucadiagram.Code;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Display
implements Iterable<CharSequence> {
    private final List<CharSequence> display = new ArrayList<CharSequence>();

    private Display(Display display) {
        this.display.addAll(display.display);
    }

    public Display() {
    }

    public Display(List<? extends CharSequence> list) {
        this.display.addAll(list);
    }

    public Display underlined() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CharSequence charSequence : this.display) {
            arrayList.add("<u>" + charSequence);
        }
        return new Display(arrayList);
    }

    public String toString() {
        return this.display.toString();
    }

    public int hashCode() {
        return ((Object)this.display).hashCode();
    }

    public boolean equals(Object object) {
        return ((Object)this.display).equals(((Display)object).display);
    }

    public Display addAll(Display display) {
        Display display2 = new Display(this);
        display2.display.addAll(display.display);
        return display2;
    }

    public Display addFirst(CharSequence charSequence) {
        Display display = new Display(this);
        display.display.add(0, charSequence);
        return display;
    }

    public Display add(CharSequence charSequence) {
        Display display = new Display(this);
        display.display.add(charSequence);
        return display;
    }

    private boolean firstColumnRemovable() {
        boolean bl = true;
        for (CharSequence charSequence : this) {
            if (charSequence.length() == 0) continue;
            bl = false;
            char c = charSequence.charAt(0);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return !bl;
    }

    public Display removeEmptyColumns() {
        if (!this.firstColumnRemovable()) {
            return this;
        }
        Display display = new Display(this);
        do {
            for (int i = 0; i < display.size(); ++i) {
                CharSequence charSequence = display.get(i);
                if (charSequence.length() <= 0) continue;
                display.display.set(i, ((Object)charSequence).toString().substring(1));
            }
        } while (display.firstColumnRemovable());
        return display;
    }

    public int size() {
        return this.display.size();
    }

    public CharSequence get(int n) {
        return this.display.get(n);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Collections.unmodifiableList(this.display).iterator();
    }

    public Display subList(int n, int n2) {
        return new Display(this.display.subList(n, n2));
    }

    public static Display asList(CharSequence ... charSequenceArray) {
        return new Display(Arrays.asList(charSequenceArray));
    }

    public static Display emptyList() {
        return new Display();
    }

    public List<? extends CharSequence> as() {
        return Collections.unmodifiableList(this.display);
    }

    public static Display getWithNewlines(Code code) {
        return Display.getWithNewlines(code.getCode());
    }

    public static Display getWithNewlines(String string) {
        if (string == null) {
            return null;
        }
        Display display = new Display();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < string.length() - 1) {
                char c2 = string.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    display.display.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                if (c2 == '\\') {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append(c);
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        display.display.add(stringBuilder.toString());
        return display;
    }

    public Url initUrl() {
        if (this.size() == 0) {
            return null;
        }
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.AT_START);
        return urlBuilder.getUrl(((Object)this.get(0)).toString().trim());
    }

    public Display removeUrl(Url url) {
        if (url == null) {
            return this;
        }
        Display display = new Display();
        display.display.add(UrlBuilder.purgeUrl(((Object)this.get(0)).toString()));
        display.display.addAll(this.subList((int)1, (int)this.size()).display);
        return display;
    }
}

