/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DotData
implements PortionShower {
    private final List<Link> links;
    private final Collection<ILeaf> leafs;
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final Rankdir rankdir;
    private final GroupHierarchy groupHierarchy;
    private final IGroup topParent;
    private final PortionShower portionShower;
    private final boolean isHideEmptyDescriptionForState;
    private final ColorMapper colorMapper;
    private final EntityFactory entityFactory;

    public DotData(IGroup iGroup, List<Link> list, Collection<ILeaf> collection, UmlDiagramType umlDiagramType, ISkinParam iSkinParam, Rankdir rankdir, GroupHierarchy groupHierarchy, PortionShower portionShower, ColorMapper colorMapper, EntityFactory entityFactory, boolean bl) {
        this.topParent = iGroup;
        if (iGroup == null) {
            throw new IllegalArgumentException();
        }
        this.isHideEmptyDescriptionForState = bl;
        this.colorMapper = colorMapper;
        this.links = list;
        this.leafs = collection;
        this.umlDiagramType = umlDiagramType;
        this.skinParam = iSkinParam;
        this.rankdir = rankdir;
        this.groupHierarchy = groupHierarchy;
        this.portionShower = portionShower;
        this.entityFactory = entityFactory;
    }

    public DotData(IGroup iGroup, List<Link> list, Collection<ILeaf> collection, UmlDiagramType umlDiagramType, ISkinParam iSkinParam, Rankdir rankdir, GroupHierarchy groupHierarchy, ColorMapper colorMapper, EntityFactory entityFactory, boolean bl) {
        this(iGroup, list, collection, umlDiagramType, iSkinParam, rankdir, groupHierarchy, new PortionShower(){

            public boolean showPortion(EntityPortion entityPortion, ILeaf iLeaf) {
                return true;
            }
        }, colorMapper, entityFactory, bl);
    }

    public UmlDiagramType getUmlDiagramType() {
        return this.umlDiagramType;
    }

    public ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public Rankdir getRankdir() {
        return this.rankdir;
    }

    public GroupHierarchy getGroupHierarchy() {
        return this.groupHierarchy;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Collection<ILeaf> getLeafs() {
        return this.leafs;
    }

    public final IGroup getTopParent() {
        return this.topParent;
    }

    public boolean isEmpty(IGroup iGroup) {
        return this.groupHierarchy.isEmpty(iGroup);
    }

    @Override
    public boolean showPortion(EntityPortion entityPortion, ILeaf iLeaf) {
        return this.portionShower.showPortion(entityPortion, iLeaf);
    }

    public final ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public IGroup getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    public final boolean isHideEmptyDescriptionForState() {
        return this.isHideEmptyDescriptionForState;
    }
}

