/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.cucadiagram.dot.AbstractGraphviz;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;

public class GraphvizCached
implements Graphviz {
    private final AbstractGraphviz graphviz;

    public GraphvizCached(AbstractGraphviz abstractGraphviz) {
        this.graphviz = abstractGraphviz;
    }

    public void createFile(OutputStream outputStream) throws IOException, InterruptedException {
        File file = this.getCachedFile();
        if (file.exists()) {
            Log.info("Using " + file);
            FileUtils.copyToStream(file, outputStream);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.graphviz.createFile(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Log.info("Creating " + file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ((OutputStream)bufferedOutputStream).write(byArray);
        ((OutputStream)bufferedOutputStream).close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileUtils.copyToStream(byteArrayInputStream, outputStream);
        ((InputStream)byteArrayInputStream).close();
    }

    private File getCachedFile() throws FileNotFoundException {
        String string = this.graphviz.getDotString();
        List<String> list = this.graphviz.getType();
        String string2 = SignatureUtils.getSignature(string + list);
        File file = new File("__graphviz", string2);
        if (!file.exists()) {
            File file2 = new File("__graphviz", string2 + ".txt");
            file2.getParentFile().mkdirs();
            PrintWriter printWriter = new PrintWriter(file2);
            printWriter.println(list.toString());
            printWriter.println(string);
            printWriter.close();
        }
        return file;
    }

    public String dotVersion() throws IOException, InterruptedException {
        return this.graphviz.dotVersion();
    }

    public File getDotExe() {
        return this.graphviz.getDotExe();
    }
}

