/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkElement
extends SingleLineCommand2<DescriptionDiagram> {
    public CommandLinkElement() {
        super(CommandLinkElement.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkElement.getGroup("ENT1"), new RegexLeaf("\\s*"), new RegexLeaf("LABEL1", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexLeaf("HEAD2", "(0\\)|<<|[<^*+#0)]|<\\|| +o)?"), new RegexLeaf("BODY", "([-=.~]+)(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.~0()]))?(?:(0|\\(0\\)|\\(0|0\\))(?=[-=.~]))?([-=.~]*)"), new RegexLeaf("HEAD1", "(\\(0|>>|[>^*+#0(]|\\|>|o +)?"), new RegexLeaf("\\s*"), new RegexLeaf("LABEL2", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), CommandLinkElement.getGroup("ENT2"), new RegexLeaf("\\s*"), new RegexLeaf("LABEL_LINK", "(?::\\s*(.+))?$"));
    }

    private LinkType getLinkType(RegexResult regexResult) {
        String string = CommandLinkElement.trimAndLowerCase(regexResult.get("HEAD1", 0));
        String string2 = CommandLinkElement.trimAndLowerCase(regexResult.get("HEAD2", 0));
        LinkDecor linkDecor = LinkDecor.NONE;
        LinkDecor linkDecor2 = LinkDecor.NONE;
        if (string.equals("(0")) {
            linkDecor = LinkDecor.CIRCLE_CONNECT;
        } else if (string.equals("#")) {
            linkDecor = LinkDecor.SQUARRE;
        } else if (string.equals("0")) {
            linkDecor = LinkDecor.CIRCLE;
        } else if (string.equals("(")) {
            linkDecor = LinkDecor.PARENTHESIS;
        } else if (string.equals(">")) {
            linkDecor = LinkDecor.ARROW;
        } else if (string.equals("*")) {
            linkDecor = LinkDecor.COMPOSITION;
        } else if (string.equals("o")) {
            linkDecor = LinkDecor.AGREGATION;
        } else if (string.equals("+")) {
            linkDecor = LinkDecor.PLUS;
        } else if (string.equals(">>")) {
            linkDecor = LinkDecor.ARROW_TRIANGLE;
        } else if (string.equals("^")) {
            linkDecor = LinkDecor.EXTENDS;
        } else if (string.equals("|>")) {
            linkDecor = LinkDecor.EXTENDS;
        }
        if (string2.equals("0)")) {
            linkDecor2 = LinkDecor.CIRCLE_CONNECT;
        } else if (string2.equals("#")) {
            linkDecor2 = LinkDecor.SQUARRE;
        } else if (string2.equals("0")) {
            linkDecor2 = LinkDecor.CIRCLE;
        } else if (string2.equals(")")) {
            linkDecor2 = LinkDecor.PARENTHESIS;
        } else if (string2.equals("<")) {
            linkDecor2 = LinkDecor.ARROW;
        } else if (string2.equals("*")) {
            linkDecor2 = LinkDecor.COMPOSITION;
        } else if (string2.equals("o")) {
            linkDecor2 = LinkDecor.AGREGATION;
        } else if (string2.equals("+")) {
            linkDecor2 = LinkDecor.PLUS;
        } else if (string2.equals("<<")) {
            linkDecor2 = LinkDecor.ARROW_TRIANGLE;
        } else if (string2.equals("^")) {
            linkDecor2 = LinkDecor.EXTENDS;
        } else if (string2.equals("<|")) {
            linkDecor2 = LinkDecor.EXTENDS;
        }
        LinkType linkType = new LinkType(linkDecor, linkDecor2);
        String string3 = CommandLinkElement.trimAndLowerCase(regexResult.get("BODY", 0));
        if (string3.contains(".")) {
            linkType = linkType.getDashed();
        } else if (string3.contains("~")) {
            linkType = linkType.getDotted();
        } else if (string3.contains("=")) {
            linkType = linkType.getBold();
        }
        String string4 = regexResult.get("BODY", 2);
        if ("0".equals(string4)) {
            linkType = linkType.withMiddleCircle();
        } else if ("0)".equals(string4)) {
            linkType = linkType.withMiddleCircleCircled1();
        } else if ("(0".equals(string4)) {
            linkType = linkType.withMiddleCircleCircled2();
        } else if ("(0)".equals(string4)) {
            linkType = linkType.withMiddleCircleCircled();
        }
        return linkType;
    }

    private static String trimAndLowerCase(String string) {
        if (string == null) {
            return "";
        }
        return string.trim().toLowerCase();
    }

    private Direction getDirection(RegexResult regexResult) {
        String string = regexResult.get("BODY", 1);
        if (string == null) {
            return Direction.DOWN;
        }
        return StringUtils.getQueueDirection(string);
    }

    private String getQueue(RegexResult regexResult) {
        return regexResult.get("BODY", 0).trim() + regexResult.get("BODY", 3).trim();
    }

    private static RegexLeaf getGroup(String string) {
        return new RegexLeaf(string, "([\\p{L}0-9_.]+|\\(\\)\\s*[\\p{L}0-9_.]+|\\(\\)\\s*\"[^\"]+\"|:[^:]+:|(?!\\[\\*\\])\\[[^\\[\\]]+\\]|\\((?!\\*\\))[^)]+\\))(?:\\s*(\\<\\<.*\\>\\>))?");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram descriptionDiagram, RegexResult regexResult) {
        Code code = Code.of(regexResult.get("ENT1", 0));
        Code code2 = Code.of(regexResult.get("ENT2", 0));
        if (descriptionDiagram.isGroup(code) && descriptionDiagram.isGroup(code2)) {
            return this.executePackageLink(descriptionDiagram, regexResult);
        }
        if (descriptionDiagram.isGroup(code) || descriptionDiagram.isGroup(code2)) {
            return CommandExecutionResult.error("Package can be only linked to other package");
        }
        ILeaf iLeaf = this.getOrCreateLeaf(descriptionDiagram, code);
        ILeaf iLeaf2 = this.getOrCreateLeaf(descriptionDiagram, code2);
        if (regexResult.get("ENT1", 1) != null) {
            iLeaf.setStereotype(new Stereotype(regexResult.get("ENT1", 1)));
        }
        if (regexResult.get("ENT2", 1) != null) {
            iLeaf2.setStereotype(new Stereotype(regexResult.get("ENT2", 1)));
        }
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        String string = direction == Direction.LEFT || direction == Direction.RIGHT ? "-" : this.getQueue(regexResult);
        Labels labels = new Labels(regexResult);
        Link link = new Link(iLeaf, iLeaf2, linkType, Display.getWithNewlines(labels.labelLink), string.length(), labels.firstLabel, labels.secondLabel, descriptionDiagram.getLabeldistance(), descriptionDiagram.getLabelangle());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        descriptionDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private ILeaf getOrCreateLeaf(DescriptionDiagram descriptionDiagram, Code code) {
        char c;
        String string = code.getCode();
        if (string.startsWith("()")) {
            return descriptionDiagram.getOrCreateLeaf1(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string.substring(2).trim())), LeafType.CIRCLE_INTERFACE);
        }
        char c2 = c = string.length() > 2 ? string.charAt(0) : (char)'\u0000';
        if (c == '(') {
            return descriptionDiagram.getOrCreateLeaf1(code.eventuallyRemoveStartingAndEndingDoubleQuote(), LeafType.USECASE);
        }
        if (c == ':') {
            return descriptionDiagram.getOrCreateLeaf1(code.eventuallyRemoveStartingAndEndingDoubleQuote(), LeafType.ACTOR);
        }
        if (c == '[') {
            return descriptionDiagram.getOrCreateLeaf1(code.eventuallyRemoveStartingAndEndingDoubleQuote(), LeafType.COMPONENT);
        }
        return descriptionDiagram.getOrCreateLeaf1(code, null);
    }

    private CommandExecutionResult executePackageLink(DescriptionDiagram descriptionDiagram, RegexResult regexResult) {
        Code code = Code.of(regexResult.get("ENT1", 0));
        Code code2 = Code.of(regexResult.get("ENT2", 0));
        IGroup iGroup = descriptionDiagram.getGroup(code);
        IGroup iGroup2 = descriptionDiagram.getGroup(code2);
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        String string = direction == Direction.LEFT || direction == Direction.RIGHT ? "-" : this.getQueue(regexResult);
        Link link = new Link(iGroup, iGroup2, linkType, Display.getWithNewlines(regexResult.get("LABEL_LINK", 0)), string.length());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        descriptionDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    static class Labels {
        private String firstLabel;
        private String secondLabel;
        private String labelLink;

        Labels(RegexResult regexResult) {
            this.firstLabel = regexResult.get("LABEL1", 0);
            this.secondLabel = regexResult.get("LABEL2", 0);
            this.labelLink = regexResult.get("LABEL_LINK", 0);
            if (this.labelLink != null) {
                if (this.firstLabel == null && this.secondLabel == null) {
                    this.init();
                }
                this.labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(this.labelLink);
            }
        }

        private void init() {
            Pattern pattern = Pattern.compile("^\"([^\"]+)\"([^\"]+)\"([^\"]+)\"$");
            Matcher matcher = pattern.matcher(this.labelLink);
            if (matcher.matches()) {
                this.firstLabel = matcher.group(1);
                this.labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(2).trim()).trim();
                this.secondLabel = matcher.group(3);
                return;
            }
            Pattern pattern2 = Pattern.compile("^\"([^\"]+)\"([^\"]+)$");
            Matcher matcher2 = pattern2.matcher(this.labelLink);
            if (matcher2.matches()) {
                this.firstLabel = matcher2.group(1);
                this.labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher2.group(2).trim()).trim();
                this.secondLabel = null;
                return;
            }
            Pattern pattern3 = Pattern.compile("^([^\"]+)\"([^\"]+)\"$");
            Matcher matcher3 = pattern3.matcher(this.labelLink);
            if (matcher3.matches()) {
                this.firstLabel = null;
                this.labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher3.group(1).trim()).trim();
                this.secondLabel = matcher3.group(2);
            }
        }
    }
}

