/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbededSystemLine
implements Line {
    private final List<? extends CharSequence> lines;

    public EmbededSystemLine(EmbededDiagram embededDiagram) {
        this.lines = embededDiagram.getLines().as();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        try {
            BufferedImage bufferedImage = this.getImage();
            return new Dimension2DDouble(bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return new Dimension2DDouble(42.0, 42.0);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        try {
            BufferedImage bufferedImage = this.getImage();
            UImage uImage = new UImage(bufferedImage);
            uGraphic.draw(uImage);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private BufferedImage getImage() throws IOException, InterruptedException {
        Diagram diagram = this.getSystem();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        diagram.exportDiagram(byteArrayOutputStream, 0, new FileFormatOption(FileFormat.PNG));
        byteArrayOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
        byteArrayInputStream.close();
        return bufferedImage;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return HorizontalAlignment.LEFT;
    }

    private Diagram getSystem() throws IOException, InterruptedException {
        BlockUml blockUml = new BlockUml(this.lines);
        return blockUml.getSystem();
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

