/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.DateEventUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicStrings
implements IEntityImage {
    private final HtmlColor background;
    private final UFont font;
    private final HtmlColor green;
    private final List<String> strings;
    private final BufferedImage image;
    private final GraphicPosition position;
    private final UAntiAliasing antiAliasing;
    private final ColorMapper colorMapper = new ColorMapperIdentity();
    private double minWidth;

    public GraphicStrings(List<String> list) {
        this(list, new UFont("SansSerif", 1, 14), HtmlColorUtils.getColorIfValid("#33FF02"), HtmlColorUtils.BLACK, null, null, UAntiAliasing.ANTI_ALIASING_ON);
    }

    public GraphicStrings(List<String> list, BufferedImage bufferedImage) {
        this(list, new UFont("SansSerif", 1, 14), HtmlColorUtils.getColorIfValid("#33FF02"), HtmlColorUtils.BLACK, bufferedImage, null, UAntiAliasing.ANTI_ALIASING_ON);
    }

    public GraphicStrings(List<String> list, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, UAntiAliasing uAntiAliasing) {
        this(list, uFont, htmlColor, htmlColor2, null, null, uAntiAliasing);
    }

    public GraphicStrings(List<String> list, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, BufferedImage bufferedImage, GraphicPosition graphicPosition, UAntiAliasing uAntiAliasing) {
        this.strings = list;
        this.font = uFont;
        this.green = htmlColor;
        this.background = htmlColor2;
        this.image = bufferedImage;
        this.position = graphicPosition;
        this.antiAliasing = uAntiAliasing;
    }

    public void writeImage(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        this.writeImage(outputStream, null, fileFormatOption);
    }

    private void writeImage(OutputStream outputStream, String string, FileFormatOption fileFormatOption) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage bufferedImage = this.createImage();
            PngIO.write((RenderedImage)bufferedImage, outputStream, string, 96);
        } else if (fileFormat == FileFormat.SVG) {
            UGraphicSvg uGraphicSvg = new UGraphicSvg(this.colorMapper, StringUtils.getAsHtml(this.colorMapper.getMappedColor(this.background)), false);
            this.drawAndGetSize(uGraphicSvg);
            uGraphicSvg.createXml(outputStream);
        } else if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            UGraphicTxt uGraphicTxt = new UGraphicTxt();
            this.drawAndGetSize(uGraphicTxt);
            uGraphicTxt.getCharArea().print(new PrintStream(outputStream));
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps uGraphicEps = new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            this.drawAndGetSize(uGraphicEps);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public ImageData exportDiagram(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        return this.exportDiagram(outputStream, null, fileFormatOption);
    }

    public ImageData exportDiagram(OutputStream outputStream, String string, FileFormatOption fileFormatOption) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage bufferedImage = this.createImage();
            PngIO.write((RenderedImage)bufferedImage, outputStream, string, 96);
        } else if (fileFormat == FileFormat.SVG) {
            UGraphicSvg uGraphicSvg = new UGraphicSvg(this.colorMapper, StringUtils.getAsHtml(this.colorMapper.getMappedColor(this.background)), false);
            this.drawAndGetSize(uGraphicSvg);
            uGraphicSvg.createXml(outputStream);
        } else if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            UGraphicTxt uGraphicTxt = new UGraphicTxt();
            this.drawAndGetSize(uGraphicTxt);
            uGraphicTxt.getCharArea().print(new PrintStream(outputStream));
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps uGraphicEps = new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            this.drawAndGetSize(uGraphicEps);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
        return new ImageDataSimple();
    }

    private BufferedImage createImage() {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, this.colorMapper.getMappedColor(this.background));
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        Dimension2D dimension2D = this.drawAndGetSize(new UGraphicG2d(this.colorMapper, graphics2D, 1.0));
        graphics2D.dispose();
        emptyImageBuilder = new EmptyImageBuilder(dimension2D.getWidth(), dimension2D.getHeight(), this.colorMapper.getMappedColor(this.background));
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        graphics2D = emptyImageBuilder.getGraphics2D();
        this.drawAndGetSize(new UGraphicG2d(this.colorMapper, graphics2D, 1.0).apply(this.antiAliasing));
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setMinWidth(double d) {
        this.minWidth = d;
    }

    private Dimension2D getSizeWithMin(Dimension2D dimension2D) {
        if (this.minWidth == 0.0) {
            return dimension2D;
        }
        if (dimension2D.getWidth() < this.minWidth) {
            return new Dimension2DDouble(this.minWidth, dimension2D.getHeight());
        }
        return dimension2D;
    }

    private Dimension2D drawAndGetSize(UGraphic uGraphic) {
        TextBlock textBlock = TextBlockUtils.create(new Display(this.strings), new FontConfiguration(this.font, this.green), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock = DateEventUtils.addEvent(textBlock, this.green);
        Dimension2D dimension2D = this.getSizeWithMin(textBlock.calculateDimension(uGraphic.getStringBounder()));
        textBlock.drawU(uGraphic);
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                uGraphic.apply(new UTranslate((dimension2D.getWidth() - (double)this.image.getWidth()) / 2.0, dimension2D.getHeight())).draw(new UImage(this.image));
                dimension2D = new Dimension2DDouble(dimension2D.getWidth(), dimension2D.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER) {
                uGraphic.apply(new UTranslate(dimension2D.getWidth() - (double)this.image.getWidth(), dimension2D.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            }
        }
        return dimension2D;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.drawAndGetSize(uGraphic);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        TextBlock textBlock = TextBlockUtils.create(new Display(this.strings), new FontConfiguration(this.font, this.green), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        return this.getSizeWithMin(textBlock.calculateDimension(stringBounder));
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.background;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public final List<Url> getUrls() {
        return Collections.emptyList();
    }
}

