/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TileImage;
import net.sourceforge.plantuml.graphic.TileImageSvg;

public class Img
implements HtmlCommand {
    private static final Pattern srcPattern = Pattern.compile("(?i)src\\s*=\\s*[\"']?([^ \">]+)[\"']?");
    private static final Pattern vspacePattern = Pattern.compile("(?i)vspace\\s*=\\s*[\"']?(\\d+)[\"']?");
    private static final Pattern valignPattern = Pattern.compile("(?i)valign\\s*=\\s*[\"']?(top|bottom|middle)[\"']?");
    private static final Pattern noSrcColonPattern = Pattern.compile("(?i)\\<img[\\s:]+([^>]+)/?\\>");
    private final TextBlock tileImage;

    private Img(TextBlock textBlock) throws IOException {
        this.tileImage = textBlock;
    }

    static int getVspace(String string) {
        Matcher matcher = vspacePattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return Integer.parseInt(matcher.group(1));
    }

    static ImgValign getValign(String string) {
        Matcher matcher = valignPattern.matcher(string);
        if (!matcher.find()) {
            return ImgValign.TOP;
        }
        return ImgValign.valueOf(matcher.group(1).toUpperCase());
    }

    static HtmlCommand getInstance(String string, boolean bl) {
        if (bl) {
            Matcher matcher = srcPattern.matcher(string);
            int n = Img.getVspace(string);
            ImgValign imgValign = Img.getValign(string);
            return Img.build(matcher, imgValign, n);
        }
        Matcher matcher = noSrcColonPattern.matcher(string);
        return Img.build(matcher, ImgValign.TOP, 0);
    }

    private static HtmlCommand build(Matcher matcher, ImgValign imgValign, int n) {
        if (!matcher.find()) {
            return new Text("(SYNTAX ERROR)");
        }
        String string = matcher.group(1);
        try {
            File file = FileSystem.getInstance().getFile(string);
            if (!file.exists()) {
                if (string.startsWith("http:") || string.startsWith("https:")) {
                    byte[] byArray = Img.getFile(string);
                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                    if (bufferedImage == null) {
                        return new Text("(Cannot decode: " + string + ")");
                    }
                    return new Img(new TileImage(bufferedImage, imgValign, n));
                }
                return new Text("(File not found: " + file + ")");
            }
            if (file.getName().endsWith(".svg")) {
                return new Img(new TileImageSvg(file));
            }
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                return new Text("(Cannot decode: " + file + ")");
            }
            return new Img(new TileImage(ImageIO.read(file), imgValign, n));
        }
        catch (IOException iOException) {
            return new Text("ERROR " + iOException.toString());
        }
    }

    public TextBlock createMonoImage() {
        return this.tileImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getFile(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            int n;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

