/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockGeneric
implements TextBlock {
    private final TextBlock textBlock;
    private final HtmlColor background;
    private final HtmlColor border;

    public TextBlockGeneric(TextBlock textBlock, HtmlColor htmlColor, HtmlColor htmlColor2) {
        this.textBlock = textBlock;
        this.border = htmlColor2;
        this.background = htmlColor;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return dimension2D;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeBackColor(this.background));
        uGraphic = uGraphic.apply(new UChangeColor(this.border));
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        uGraphic.apply(new UStroke(2.0, 2.0, 1.0)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        this.textBlock.drawU(uGraphic);
    }

    @Override
    public List<Url> getUrls() {
        return this.textBlock.getUrls();
    }
}

