/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockLineBefore2
implements TextBlock {
    private final TextBlock textBlock;
    private final char separator;
    private final TextBlock title;

    public TextBlockLineBefore2(TextBlock textBlock, char c, TextBlock textBlock2) {
        this.textBlock = textBlock;
        this.separator = c;
        this.title = textBlock2;
    }

    public TextBlockLineBefore2(TextBlock textBlock, char c) {
        this(textBlock, c, null);
    }

    public TextBlockLineBefore2(TextBlock textBlock) {
        this(textBlock, '\u0000');
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        if (this.title != null) {
            Dimension2D dimension2D2 = this.title.calculateDimension(stringBounder);
            return Dimension2DDouble.atLeast(dimension2D, dimension2D2.getWidth() + 8.0, dimension2D2.getHeight());
        }
        return dimension2D;
    }

    private void drawLine(UGraphic uGraphic, double d, UHorizontalLine uHorizontalLine) {
        if (this.separator == '=') {
            uGraphic.apply(new UTranslate(0.0, d)).draw(uHorizontalLine);
            uGraphic.apply(new UTranslate(0.0, d + 2.0)).draw(uHorizontalLine.blankTitle());
        } else {
            uGraphic.apply(new UTranslate(0.0, d)).draw(uHorizontalLine);
        }
    }

    private UStroke getStroke() {
        if (this.separator == '\u0000') {
            return null;
        }
        if (this.separator == '=') {
            return new UStroke();
        }
        if (this.separator == '.') {
            return new UStroke(1.0, 2.0, 1.0);
        }
        if (this.separator == '-') {
            return new UStroke();
        }
        return new UStroke(1.5);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        HtmlColor htmlColor = uGraphic.getParam().getColor();
        if (this.title == null) {
            this.drawLine(uGraphic, 0.0, UHorizontalLine.infinite(1.0, 1.0, this.getStroke()));
        }
        this.textBlock.drawU(uGraphic);
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor));
        if (this.title != null) {
            this.drawLine(uGraphic, 0.0, UHorizontalLine.infinite(1.0, 1.0, this.title, this.getStroke()));
        }
    }

    @Override
    public List<Url> getUrls() {
        return this.textBlock.getUrls();
    }
}

