/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolFrame
extends USymbol {
    USymbolFrame() {
    }

    private void drawFrame(UGraphic uGraphic, double d, double d2, Dimension2D dimension2D, boolean bl) {
        int n;
        double d3;
        URectangle uRectangle = new URectangle(d, d2);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(uRectangle);
        if (dimension2D.getWidth() == 0.0) {
            d3 = d / 3.0;
            n = 7;
        } else {
            d3 = dimension2D.getWidth() + 10.0;
            n = 10;
        }
        double d4 = this.getYpos(dimension2D);
        UPath uPath = new UPath();
        uPath.moveTo(d3, 1.0);
        uPath.lineTo(d3, d4 - (double)n);
        uPath.lineTo(d3 - (double)n, d4);
        uPath.lineTo(0.0, d4);
        uGraphic.draw(uPath);
    }

    private double getYpos(Dimension2D dimension2D) {
        if (dimension2D.getWidth() == 0.0) {
            return 12.0;
        }
        return dimension2D.getHeight() + 3.0;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolFrame.this.drawFrame(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), new Dimension2DDouble(0.0, 0.0), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolFrame.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
                textBlock3.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolFrame.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                Dimension2D dimension2D = this.calculateDimension(stringBounder);
                uGraphic = symbolContext.apply(uGraphic);
                Dimension2D dimension2D2 = textBlock.calculateDimension(stringBounder);
                USymbolFrame.this.drawFrame(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), dimension2D2, symbolContext.isShadowing());
                textBlock.drawU(uGraphic.apply(new UTranslate(3.0, 1.0)));
                Dimension2D dimension2D3 = textBlock2.calculateDimension(stringBounder);
                double d3 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic.apply(new UTranslate(4.0 + d3, 2.0 + USymbolFrame.this.getYpos(dimension2D2))));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }
}

