/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StartUtils;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public StartDiagramExtractReader(File file, int n, String string) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.raw = StartDiagramExtractReader.getReadLine(file, string);
        String string2 = null;
        while ((string2 = this.raw.readLine()) != null) {
            if (!StartUtils.isArobaseStartDiagram(string2)) continue;
            if (n == 0) {
                return;
            }
            --n;
        }
        this.finished = true;
    }

    private static ReadLine getReadLine(File file, String string) throws IOException {
        if (string == null) {
            Log.info("Using default charset");
            return new UncommentReadLine(new ReadLineReader(new FileReader(file)));
        }
        Log.info("Using charset " + string);
        return new UncommentReadLine(new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(file), string)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsStartDiagram(File file, String string) throws IOException {
        ReadLine readLine = null;
        try {
            readLine = StartDiagramExtractReader.getReadLine(file, string);
            String string2 = null;
            while ((string2 = readLine.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(string2)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (readLine != null) {
                readLine.close();
            }
        }
        return false;
    }

    public String readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        String string = this.raw.readLine();
        if (string != null && StartUtils.isArobaseEndDiagram(string)) {
            this.finished = true;
            return null;
        }
        return string;
    }

    public void close() throws IOException {
        this.raw.close();
    }
}

