/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementMenuEntry;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementMenuPopup
implements Element {
    private final Collection<ElementMenuEntry> entries = new ArrayList<ElementMenuEntry>();
    private final UFont font;
    private final SpriteContainer spriteContainer;

    public ElementMenuPopup(UFont uFont, SpriteContainer spriteContainer) {
        this.font = uFont;
        this.spriteContainer = spriteContainer;
    }

    public void addEntry(String string) {
        this.entries.add(new ElementMenuEntry(string, this.font, this.spriteContainer));
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (ElementMenuEntry elementMenuEntry : this.entries) {
            Dimension2D dimension2D = elementMenuEntry.getPreferredDimension(stringBounder, d, d2);
            d3 = Math.max(d3, dimension2D.getWidth());
            d4 += dimension2D.getHeight();
        }
        return new Dimension2DDouble(d3, d4);
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        if (n != 1) {
            return;
        }
        uGraphic.apply(new UChangeBackColor(HtmlColorUtils.getColorIfValid("#DDDDDD"))).apply(new UTranslate(d, d2)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        for (ElementMenuEntry elementMenuEntry : this.entries) {
            double d3 = elementMenuEntry.getPreferredDimension(uGraphic.getStringBounder(), d, d2).getHeight();
            if (elementMenuEntry.getText().equals("-")) {
                uGraphic.apply(new UTranslate(d, d2 + d3 / 2.0)).draw(new ULine(dimension2D.getWidth(), 0.0));
            } else {
                elementMenuEntry.drawU(uGraphic, d, d2, n, dimension2D);
            }
            d2 += d3;
        }
    }
}

