/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBoxStart
extends SingleLineCommand<SequenceDiagram> {
    public CommandBoxStart() {
        super("(?i)^box(?:\\s+\"([^\"]+)\")?(?:\\s+(#\\w+))?$");
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, List<String> list) {
        if (sequenceDiagram.isBoxPending()) {
            return CommandExecutionResult.error("Box cannot be nested");
        }
        HtmlColor htmlColor = HtmlColorUtils.getColorIfValid(list.get(1));
        String string = list.get(0) == null ? "" : list.get(0);
        sequenceDiagram.boxStart(Display.getWithNewlines(string), htmlColor);
        return CommandExecutionResult.ok();
    }
}

