/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class MessageArrow
extends Arrow {
    private final LivingParticipantBox p1;
    private final LivingParticipantBox p2;

    public MessageArrow(double d, Skin skin, Component component, LivingParticipantBox livingParticipantBox, LivingParticipantBox livingParticipantBox2, Url url) {
        super(d, skin, component, url);
        if (livingParticipantBox == livingParticipantBox2) {
            throw new IllegalArgumentException();
        }
        if (livingParticipantBox == null || livingParticipantBox2 == null) {
            throw new IllegalArgumentException();
        }
        this.p1 = livingParticipantBox;
        this.p2 = livingParticipantBox2;
    }

    public double getActualWidth(StringBounder stringBounder) {
        double d = this.getRightEndInternal(stringBounder) - this.getLeftStartInternal(stringBounder);
        assert (d > 0.0);
        return d;
    }

    private double getLeftStartInternal(StringBounder stringBounder) {
        return this.getParticipantAt(stringBounder, NotePosition.LEFT).getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2();
    }

    private double getRightEndInternal(StringBounder stringBounder) {
        return this.getParticipantAt(stringBounder, NotePosition.RIGHT).getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos1();
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    public double getStartingX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    public int getDirection(StringBounder stringBounder) {
        double d;
        double d2 = this.p1.getParticipantBox().getCenterX(stringBounder);
        if (d2 < (d = this.p2.getParticipantBox().getCenterX(stringBounder))) {
            return 1;
        }
        return -1;
    }

    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition notePosition) {
        int n = this.getDirection(stringBounder);
        if (n == 1 && notePosition == NotePosition.RIGHT) {
            return this.p2;
        }
        if (n == 1 && notePosition == NotePosition.LEFT) {
            return this.p1;
        }
        if (n == -1 && notePosition == NotePosition.RIGHT) {
            return this.p1;
        }
        if (n == -1 && notePosition == NotePosition.LEFT) {
            return this.p2;
        }
        throw new IllegalArgumentException();
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredWidth(stringBounder);
    }

    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UTranslate(this.getStartingX(stringBounder), this.getStartingY()));
        this.startUrl(uGraphic);
        this.getArrowComponent().drawU(uGraphic, new Area(this.getActualDimension(stringBounder)), context2D);
        this.endUrl(uGraphic);
    }

    private Dimension2D getActualDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getActualWidth(stringBounder) - this.getPaddingArrowHead(), this.getArrowComponent().getPreferredHeight(stringBounder));
    }

    public double getArrowYStartLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = (ArrowComponent)this.getArrowComponent();
            Dimension2DDouble dimension2DDouble = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getStartPoint(stringBounder, dimension2DDouble).getY();
        }
        return this.getStartingY();
    }

    public double getArrowYEndLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = (ArrowComponent)this.getArrowComponent();
            Dimension2DDouble dimension2DDouble = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getEndPoint(stringBounder, dimension2DDouble).getY();
        }
        return this.getStartingY() + this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    public double getMaxX(StringBounder stringBounder) {
        return this.getRightEndInternal(stringBounder);
    }

    public double getMinX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    public String toString(StringBounder stringBounder) {
        return this.getMinX(stringBounder) + "-" + this.getMaxX(stringBounder);
    }
}

