/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class MessageExoArrow
extends Arrow {
    private final LivingParticipantBox p;
    private final MessageExoType type;
    private final boolean shortArrow;

    public MessageExoArrow(double d, Skin skin, Component component, LivingParticipantBox livingParticipantBox, MessageExoType messageExoType, Url url, boolean bl) {
        super(d, skin, component, url);
        this.p = livingParticipantBox;
        this.type = messageExoType;
        this.shortArrow = bl;
    }

    double getActualWidth(StringBounder stringBounder, double d) {
        double d2 = this.getRightEndInternal(stringBounder, d) - this.getLeftStartInternal(stringBounder);
        assert (d2 > 0.0);
        return d2;
    }

    private double getLeftStartInternal(StringBounder stringBounder) {
        if (this.type == MessageExoType.FROM_LEFT || this.type == MessageExoType.TO_LEFT) {
            if (this.shortArrow) {
                return this.p.getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2() - this.getPreferredWidth(stringBounder);
            }
            return 0.0;
        }
        return this.p.getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2();
    }

    private double getRightEndInternal(StringBounder stringBounder, double d) {
        if (this.type == MessageExoType.FROM_LEFT || this.type == MessageExoType.TO_LEFT) {
            return this.p.getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos1();
        }
        if (this.shortArrow) {
            return this.getLeftStartInternal(stringBounder) + this.getPreferredWidth(stringBounder);
        }
        return Math.max(d, this.getLeftStartInternal(stringBounder) + this.getPreferredWidth(stringBounder));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    public double getStartingX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    public int getDirection(StringBounder stringBounder) {
        return this.type.getDirection();
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredWidth(stringBounder);
    }

    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UTranslate(this.getStartingX(stringBounder), this.getStartingY()));
        this.startUrl(uGraphic);
        this.getArrowComponent().drawU(uGraphic, new Area(this.getActualDimension(stringBounder, d)), context2D);
        this.endUrl(uGraphic);
    }

    private Dimension2D getActualDimension(StringBounder stringBounder, double d) {
        return new Dimension2DDouble(this.getActualWidth(stringBounder, d), this.getArrowComponent().getPreferredHeight(stringBounder));
    }

    public double getArrowYStartLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = (ArrowComponent)this.getArrowComponent();
            Dimension2DDouble dimension2DDouble = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getStartPoint(stringBounder, dimension2DDouble).getY();
        }
        return this.getStartingY();
    }

    public double getArrowYEndLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = (ArrowComponent)this.getArrowComponent();
            Dimension2DDouble dimension2DDouble = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getEndPoint(stringBounder, dimension2DDouble).getY();
        }
        return this.getStartingY() + this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    public double getMaxX(StringBounder stringBounder) {
        return this.getRightEndInternal(stringBounder, 0.0);
    }

    public double getMinX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    public String toString(StringBounder stringBounder) {
        return this.getMinX(stringBounder) + "-" + this.getMaxX(stringBounder);
    }

    public final MessageExoType getType() {
        return this.type;
    }

    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition notePosition) {
        return this.p;
    }

    public double getActualWidth(StringBounder stringBounder) {
        return this.getActualWidth(stringBounder, this.getMaxX());
    }
}

