/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

final class NotesBoxes
extends GraphicalElement
implements InGroupable {
    private final List<NoteBox> notes = new ArrayList<NoteBox>();
    private final List<ParticipantBox> participants = new ArrayList<ParticipantBox>();

    NotesBoxes(double d) {
        super(d);
    }

    public void add(NoteBox noteBox, ParticipantBox participantBox) {
        this.notes.add(noteBox);
        this.participants.add(participantBox);
    }

    public void ensureConstraints(StringBounder stringBounder, ConstraintSet constraintSet) {
        for (int i = 0; i < this.notes.size(); ++i) {
            NoteBox noteBox = this.notes.get(i);
            ParticipantBox participantBox = this.participants.get(i);
            double d = noteBox.getPreferredWidth(stringBounder);
            constraintSet.getConstraintAfter(participantBox).ensureValue(d / 2.0);
            constraintSet.getConstraintBefore(participantBox).ensureValue(d / 2.0);
            for (int j = i + 1; j < this.notes.size(); ++j) {
                NoteBox noteBox2 = this.notes.get(j);
                ParticipantBox participantBox2 = this.participants.get(j);
                double d2 = noteBox2.getPreferredWidth(stringBounder);
                constraintSet.getConstraint(participantBox, participantBox2).ensureValue((d + d2) / 2.0);
            }
        }
    }

    public double getMinX(StringBounder stringBounder) {
        double d = Double.MAX_VALUE;
        for (NoteBox noteBox : this.notes) {
            double d2 = noteBox.getMinX(stringBounder);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxX(StringBounder stringBounder) {
        double d = -1.7976931348623157E308;
        for (NoteBox noteBox : this.notes) {
            double d2 = noteBox.getMaxX(stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public String toString(StringBounder stringBounder) {
        return this.toString();
    }

    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        for (NoteBox noteBox : this.notes) {
            noteBox.drawInternalU(uGraphic, d, context2D);
        }
    }

    public double getStartingX(StringBounder stringBounder) {
        double d = Double.MAX_VALUE;
        for (NoteBox noteBox : this.notes) {
            double d2 = noteBox.getStartingX(stringBounder);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getMaxX(stringBounder) - this.getMinX(stringBounder);
        return d;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (NoteBox noteBox : this.notes) {
            double d2 = noteBox.getPreferredHeight(stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }
}

