/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.PageSplitter;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramArea;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDiagramFileMakerPuma
implements FileMaker {
    private static final StringBounder dummyStringBounder;
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final List<Page> pages;
    private final FileFormatOption fileFormatOption;
    private final List<BufferedImage> flashcodes;
    private int offsetX;
    private int offsetY;

    public SequenceDiagramFileMakerPuma(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption, List<BufferedImage> list) {
        this.flashcodes = list;
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        DrawableSetInitializer drawableSetInitializer = new DrawableSetInitializer(skin, sequenceDiagram.getSkinParam(), sequenceDiagram.isShowFootbox(), sequenceDiagram.getAutonewpage());
        for (Participant object22 : sequenceDiagram.participants().values()) {
            drawableSetInitializer.addParticipant(object22, sequenceDiagram.getEnglober(object22));
        }
        for (Event event : sequenceDiagram.events()) {
            drawableSetInitializer.addEvent(event);
            if (!(event instanceof Message)) continue;
            Message message = (Message)event;
            for (LifeEvent lifeEvent : message.getLiveEvents()) {
                if (lifeEvent.getType() != LifeEventType.DESTROY) continue;
                drawableSetInitializer.addEvent(lifeEvent);
            }
        }
        this.drawableSet = drawableSetInitializer.createDrawableSet(dummyStringBounder);
        ArrayList arrayList = new ArrayList();
        for (Event event : this.drawableSet.getAllEvents()) {
            if (!(event instanceof Newpage)) continue;
            arrayList.add((Newpage)event);
        }
        this.fullDimension = this.drawableSet.getDimension();
        LinkedHashMap<Newpage, Double> linkedHashMap = new LinkedHashMap<Newpage, Double>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Newpage newpage = (Newpage)iterator.next();
            linkedHashMap.put(newpage, drawableSetInitializer.getYposition(dummyStringBounder, newpage));
        }
        this.pages = this.create(this.drawableSet, linkedHashMap, sequenceDiagram.isShowFootbox(), sequenceDiagram.getTitle()).getPages();
    }

    @Override
    public int getNbPages() {
        return this.pages.size();
    }

    private PageSplitter create(DrawableSet drawableSet, Map<Newpage, Double> map, boolean bl, Display display) {
        double d = drawableSet.getHeadHeight(dummyStringBounder);
        double d2 = drawableSet.getTailHeight(dummyStringBounder, bl);
        double d3 = drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, drawableSet.getSkinParam(), Display.asList("")).getPreferredHeight(dummyStringBounder);
        return new PageSplitter(this.fullDimension.getHeight(), d, map, d2, 0.0, d3, display);
    }

    @Override
    public Dimension2D createOne(OutputStream outputStream, int n) throws IOException {
        UGraphic uGraphic = this.createImage((int)this.fullDimension.getWidth(), this.pages.get(n), n);
        uGraphic.writeImage(outputStream, this.diagram.getMetadata(), this.diagram.getDpi(this.fileFormatOption));
        return new Dimension2DDouble(this.fullDimension.getWidth(), this.fullDimension.getHeight());
    }

    private double getImageWidth(SequenceDiagramArea sequenceDiagramArea, boolean bl, double d, double d2) {
        int n = this.diagram.getMinwidth();
        double d3 = Math.max(this.getImageWidthWithoutMinsize(sequenceDiagramArea, bl, d), d2);
        if (n == Integer.MAX_VALUE) {
            return d3;
        }
        if (d3 >= (double)n) {
            return d3;
        }
        return n;
    }

    private double getScale(double d, double d2) {
        if (this.diagram.getScale() == null) {
            return 1.0;
        }
        return this.diagram.getScale().getScale(d, d2);
    }

    private double getImageWidthWithoutMinsize(SequenceDiagramArea sequenceDiagramArea, boolean bl, double d) {
        double d2 = bl ? sequenceDiagramArea.getHeight() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d : sequenceDiagramArea.getWidth() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
        return d2;
    }

    private double getImageHeight(SequenceDiagramArea sequenceDiagramArea, Page page, boolean bl, double d) {
        if (bl) {
            return sequenceDiagramArea.getWidth() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
        }
        return sequenceDiagramArea.getHeight() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
    }

    private UGraphic createImage(int n, Page page, int n2) {
        UGraphic uGraphic;
        double d;
        double d2 = 0.0;
        if (n2 > 0) {
            d2 = page.getNewpage1() - page.getHeaderHeight();
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        SequenceDiagramArea sequenceDiagramArea = new SequenceDiagramArea(n, page.getHeight());
        Component component = null;
        if (page.getTitle() != null) {
            component = this.drawableSet.getSkin().createComponent(ComponentType.TITLE, null, this.drawableSet.getSkinParam(), page.getTitle());
            sequenceDiagramArea.setTitleArea(component.getPreferredWidth(dummyStringBounder), component.getPreferredHeight(dummyStringBounder));
        }
        this.addFooter2(sequenceDiagramArea);
        this.addHeader2(sequenceDiagramArea);
        this.offsetX = (int)Math.round(sequenceDiagramArea.getSequenceAreaX());
        this.offsetY = (int)Math.round(sequenceDiagramArea.getSequenceAreaY());
        Color color = null;
        if (this.diagram.getSkinParam().getBackgroundColor() instanceof HtmlColorSimple) {
            color = this.diagram.getSkinParam().getColorMapper().getMappedColor(this.diagram.getSkinParam().getBackgroundColor());
        }
        FileFormat fileFormat = this.fileFormatOption.getFileFormat();
        double d3 = this.diagram.getDpiFactor(this.fileFormatOption);
        Display display = this.diagram.getLegend();
        TextBlock textBlock = display == null ? TextBlockUtils.empty(0.0, 0.0) : EntityImageLegend.create(display, this.diagram.getSkinParam());
        Dimension2D dimension2D = TextBlockUtils.getDimension(textBlock);
        if (fileFormat == FileFormat.PNG) {
            double d4 = this.getImageHeight(sequenceDiagramArea, page, this.diagram.isRotation(), 1.0);
            if (d4 == 0.0) {
                d4 = 1.0;
            }
            d = 0.0;
            if (this.flashcodes != null) {
                d = this.flashcodes.get(0).getHeight();
            }
            double d5 = this.getImageWidth(sequenceDiagramArea, this.diagram.isRotation(), 1.0, dimension2D.getWidth());
            Dimension2DDouble dimension2DDouble = this.diagram.isRotation() ? new Dimension2DDouble(d4 + dimension2D.getHeight(), d5 + d) : new Dimension2DDouble(d5, d4 + d + dimension2D.getHeight());
            uGraphic = this.fileFormatOption.createUGraphic(this.diagram.getSkinParam().getColorMapper(), d3, dimension2DDouble, this.diagram.getSkinParam().getBackgroundColor(), this.diagram.isRotation());
            if (this.flashcodes != null) {
                ((UGraphicG2d)uGraphic).getGraphics2D().drawImage(this.flashcodes.get(0), null, 0, (int)d4);
            }
            AffineTransform affineTransform = ((UGraphicG2d)uGraphic).getGraphics2D().getTransform();
            affineTransform.scale(this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()), this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()));
            ((UGraphicG2d)uGraphic).getGraphics2D().setTransform(affineTransform);
        } else if (fileFormat == FileFormat.SVG) {
            uGraphic = this.diagram.getSkinParam().getBackgroundColor() instanceof HtmlColorGradient ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), (HtmlColorGradient)this.diagram.getSkinParam().getBackgroundColor(), false) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), false) : new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), StringUtils.getAsHtml(color), false));
        } else if (fileFormat == FileFormat.EPS) {
            uGraphic = new UGraphicEps(this.diagram.getSkinParam().getColorMapper(), EpsStrategy.getDefault2());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            uGraphic = new UGraphicEps(this.diagram.getSkinParam().getColorMapper(), EpsStrategy.WITH_MACRO_AND_TEXT);
        } else if (fileFormat == FileFormat.HTML5) {
            uGraphic = new UGraphicHtml5(this.diagram.getSkinParam().getColorMapper());
        } else if (fileFormat == FileFormat.VDX) {
            uGraphic = new UGraphicVdx(this.diagram.getSkinParam().getColorMapper());
        } else {
            throw new UnsupportedOperationException();
        }
        if (component != null) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            double d6 = component.getPreferredHeight(stringBounder);
            double d7 = component.getPreferredWidth(stringBounder);
            component.drawU(uGraphic.apply(new UTranslate(sequenceDiagramArea.getTitleX(), sequenceDiagramArea.getTitleY())), new Area(new Dimension2DDouble(d7, d6)), new SimpleContext2D(false));
        }
        this.addHeader3(sequenceDiagramArea, uGraphic);
        this.addFooter3(sequenceDiagramArea, uGraphic);
        double d8 = Math.max(0.0, dimension2D.getWidth() - sequenceDiagramArea.getWidth());
        this.drawableSet.drawU(uGraphic.apply(new UTranslate(sequenceDiagramArea.getSequenceAreaX() + d8 / 2.0, sequenceDiagramArea.getSequenceAreaY())), d2, n, page, this.diagram.isShowFootbox());
        if (display != null) {
            d = this.diagram.getLegendAlignment() == HorizontalAlignment.LEFT ? 0.0 : (this.diagram.getLegendAlignment() == HorizontalAlignment.RIGHT ? Math.max(0.0, sequenceDiagramArea.getWidth() - dimension2D.getWidth()) : Math.max(0.0, sequenceDiagramArea.getWidth() - dimension2D.getWidth()) / 2.0);
            textBlock.drawU(uGraphic.apply(new UTranslate(d, sequenceDiagramArea.getHeight())));
        }
        return uGraphic;
    }

    private void addFooter2(SequenceDiagramArea sequenceDiagramArea) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignment());
        Dimension2D dimension2D = pngTitler.getTextDimension(dummyStringBounder);
        if (dimension2D != null) {
            sequenceDiagramArea.setFooterArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    private void addHeader2(SequenceDiagramArea sequenceDiagramArea) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignment());
        Dimension2D dimension2D = pngTitler.getTextDimension(dummyStringBounder);
        if (dimension2D != null) {
            sequenceDiagramArea.setHeaderArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    private void addFooter3(SequenceDiagramArea sequenceDiagramArea, UGraphic uGraphic) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignment());
        TextBlock textBlock = pngTitler.getTextBlock();
        if (textBlock == null) {
            return;
        }
        textBlock.drawU(uGraphic.apply(new UTranslate(sequenceDiagramArea.getFooterX(this.diagram.getFooterAlignment()), sequenceDiagramArea.getFooterY())));
    }

    private void addHeader3(SequenceDiagramArea sequenceDiagramArea, UGraphic uGraphic) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignment());
        TextBlock textBlock = pngTitler.getTextBlock();
        if (textBlock == null) {
            return;
        }
        textBlock.drawU(uGraphic.apply(new UTranslate(sequenceDiagramArea.getHeaderX(this.diagram.getHeaderAlignment()), sequenceDiagramArea.getHeaderY())));
    }

    public static StringBounder getDummystringbounder() {
        return dummyStringBounder;
    }

    @Override
    public void appendCmap(CMapData cMapData) {
        this.drawableSet.appendCmap(cMapData, this.offsetX, this.offsetY, dummyStringBounder, this.diagram);
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        dummyStringBounder = StringBounderUtils.asStringBounder(bufferedImage.createGraphics());
    }
}

