/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

public class ArrowDressing {
    private final ArrowHead head;
    private final ArrowPart part;
    private final ArrowDecoration decoration;

    public String name() {
        return this.toString();
    }

    public String toString() {
        return this.head.name() + "*" + this.decoration.name();
    }

    private ArrowDressing(ArrowHead arrowHead, ArrowPart arrowPart, ArrowDecoration arrowDecoration) {
        if (arrowHead == null || arrowPart == null || arrowDecoration == null) {
            throw new IllegalArgumentException();
        }
        this.head = arrowHead;
        this.part = arrowPart;
        this.decoration = arrowDecoration;
    }

    public static ArrowDressing create() {
        return new ArrowDressing(ArrowHead.NONE, ArrowPart.FULL, ArrowDecoration.NONE);
    }

    public ArrowDressing withHead(ArrowHead arrowHead) {
        return new ArrowDressing(arrowHead, this.part, this.decoration);
    }

    public ArrowDressing withPart(ArrowPart arrowPart) {
        return new ArrowDressing(this.head, arrowPart, this.decoration);
    }

    public ArrowDressing withDecoration(ArrowDecoration arrowDecoration) {
        return new ArrowDressing(this.head, this.part, arrowDecoration);
    }

    public ArrowHead getHead() {
        return this.head;
    }

    public ArrowPart getPart() {
        return this.part;
    }

    public ArrowDecoration getDecoration() {
        return this.decoration;
    }
}

