/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseDivider
extends AbstractTextualComponent {
    private final HtmlColor background;
    private final boolean empty;
    private final boolean withShadow;
    private final UStroke stroke;

    public ComponentRoseDivider(HtmlColor htmlColor, UFont uFont, HtmlColor htmlColor2, Display display, SpriteContainer spriteContainer, boolean bl, UStroke uStroke) {
        super(display, htmlColor, uFont, HorizontalAlignment.CENTER, 4, 4, 4, spriteContainer, 0.0);
        this.background = htmlColor2;
        this.empty = display.get(0).length() == 0;
        this.withShadow = bl;
        this.stroke = uStroke;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextWidth(stringBounder);
        double d2 = this.getTextHeight(stringBounder);
        double d3 = (dimension2D.getWidth() - d - 6.0) / 2.0;
        double d4 = (dimension2D.getHeight() - d2) / 2.0;
        uGraphic = uGraphic.apply(new UChangeBackColor(this.background)).apply(new UChangeColor(this.background));
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), 3.0);
        if (this.withShadow) {
            uRectangle.setDeltaShadow(2.0);
        }
        uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() / 2.0 - 1.0)).draw(uRectangle);
        uGraphic = uGraphic.apply(new UStroke(this.stroke.getThickness() / 2.0)).apply(new UChangeColor(HtmlColorUtils.BLACK));
        uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() / 2.0 - 1.0)).draw(new ULine(dimension2D.getWidth(), 0.0));
        uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() / 2.0 + 2.0)).draw(new ULine(dimension2D.getWidth(), 0.0));
        if (!this.empty) {
            uGraphic = uGraphic.apply(new UChangeBackColor(this.background)).apply(new UChangeColor(HtmlColorUtils.BLACK));
            uGraphic = uGraphic.apply(this.stroke);
            URectangle uRectangle2 = new URectangle(d + 6.0, d2);
            if (this.withShadow) {
                uRectangle2.setDeltaShadow(4.0);
            }
            uGraphic.apply(new UTranslate(d3, d4)).draw(uRectangle2);
            uGraphic = uGraphic.apply(new UStroke());
            textBlock.drawU(uGraphic.apply(new UTranslate(d3 + 6.0, d4 + (double)this.getMarginY())));
        }
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

