/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SkinParamForecolored;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.skin.StickMan;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Boundary;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.Control;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.EntityDomain;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.SvekResult;
import net.sourceforge.plantuml.svek.image.EntityImageActivity;
import net.sourceforge.plantuml.svek.image.EntityImageActor2;
import net.sourceforge.plantuml.svek.image.EntityImageArcCircle;
import net.sourceforge.plantuml.svek.image.EntityImageAssociation;
import net.sourceforge.plantuml.svek.image.EntityImageAssociationPoint;
import net.sourceforge.plantuml.svek.image.EntityImageBranch;
import net.sourceforge.plantuml.svek.image.EntityImageCircleEnd;
import net.sourceforge.plantuml.svek.image.EntityImageCircleInterface;
import net.sourceforge.plantuml.svek.image.EntityImageCircleStart;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.svek.image.EntityImageComponent;
import net.sourceforge.plantuml.svek.image.EntityImageComponentForDescriptionDiagram;
import net.sourceforge.plantuml.svek.image.EntityImageEmptyPackage2;
import net.sourceforge.plantuml.svek.image.EntityImageGroup;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.EntityImageObject;
import net.sourceforge.plantuml.svek.image.EntityImagePseudoState;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.svek.image.EntityImageStateEmptyDescription;
import net.sourceforge.plantuml.svek.image.EntityImageSynchroBar;
import net.sourceforge.plantuml.svek.image.EntityImageUseCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerSvek2 {
    private final ColorSequence colorSequence = new ColorSequence();
    private final DotData dotData;
    private final EntityFactory entityFactory;
    private final boolean hasVerticalLine;
    private static final StringBounder stringBounder;
    private DotStringFactory dotStringFactory;

    public CucaDiagramFileMakerSvek2(DotData dotData, EntityFactory entityFactory, boolean bl) {
        this.dotData = dotData;
        this.entityFactory = entityFactory;
        this.hasVerticalLine = bl;
    }

    public Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    public IEntityImage createFile(String ... stringArray) throws IOException, InterruptedException {
        Moveable moveable;
        Object object;
        Object illegalStateException;
        this.dotStringFactory = new DotStringFactory(this.colorSequence, stringBounder, this.dotData);
        this.printGroups(this.dotData.getRootGroup());
        this.printEntities(this.getUnpackagedEntities());
        for (Link object32 : this.dotData.getLinks()) {
            if (object32.isRemoved()) continue;
            try {
                Shape shape;
                illegalStateException = this.getBibliotekon().getShapeUid((ILeaf)object32.getEntity1());
                String d = this.getBibliotekon().getShapeUid((ILeaf)object32.getEntity2());
                String string = null;
                if (((String)illegalStateException).startsWith("za")) {
                    string = this.getCluster2(object32.getEntity1()).getClusterId();
                }
                String d2 = null;
                if (d.startsWith("za")) {
                    d2 = this.getCluster2(object32.getEntity2()).getClusterId();
                }
                ISkinParam iSkinParam = this.dotData.getSkinParam();
                object = new FontConfiguration(iSkinParam.getFont(FontParam.GENERIC_ARROW, null), iSkinParam.getFontHtmlColor(FontParam.GENERIC_ARROW, null));
                moveable = new Line((String)illegalStateException, d, object32, this.colorSequence, string, d2, iSkinParam, stringBounder, (FontConfiguration)object, this.getBibliotekon());
                this.getBibliotekon().addLine((Line)moveable);
                if (!object32.getEntity1().isGroup() && object32.getEntity1().getEntityType() == LeafType.NOTE && this.onlyOneLink(object32.getEntity1())) {
                    shape = this.getBibliotekon().getShape(object32.getEntity1());
                    ((EntityImageNote)shape.getImage()).setOpaleLine((Line)moveable, shape);
                    ((Line)moveable).setOpale(true);
                    continue;
                }
                if (object32.getEntity2().isGroup() || object32.getEntity2().getEntityType() != LeafType.NOTE || !this.onlyOneLink(object32.getEntity2())) continue;
                shape = this.getBibliotekon().getShape(object32.getEntity2());
                ((EntityImageNote)shape.getImage()).setOpaleLine((Line)moveable, shape);
                ((Line)moveable).setOpale(true);
            }
            catch (IllegalStateException exception) {
                exception.printStackTrace();
            }
        }
        if (this.dotStringFactory.illegalDotExe()) {
            return this.error(this.dotStringFactory.getDotExe());
        }
        String string = this.dotStringFactory.getSvg(stringArray);
        String string2 = this.extractGraphvizVersion(string);
        try {
            illegalStateException = this.dotStringFactory.solve(string).delta(10.0, 10.0);
            double d = ((ClusterPosition)illegalStateException).getMinY();
            double d2 = ((ClusterPosition)illegalStateException).getMinX();
            if (d2 > 0.0 || d > 0.0) {
                throw new IllegalStateException();
            }
            object = this.dotData.getUmlDiagramType() == UmlDiagramType.STATE ? CucaDiagramFileMakerSvek2.getColor(ColorParam.stateBorder, null, this.dotData.getSkinParam()) : CucaDiagramFileMakerSvek2.getColor(ColorParam.packageBorder, null, this.dotData.getSkinParam());
            moveable = new SvekResult((ClusterPosition)illegalStateException, this.dotData, this.dotStringFactory, (HtmlColor)object, this.hasVerticalLine);
            ((SvekResult)moveable).moveSvek(6.0 - d2, -d);
            return moveable;
        }
        catch (Exception exception) {
            Log.error("Exception " + exception);
            throw new UnparsableGraphvizException(exception, string2);
        }
    }

    private String extractGraphvizVersion(String string) {
        Pattern pattern = Pattern.compile("(?mi)!-- generated by graphviz(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    private boolean onlyOneLink(IEntity iEntity) {
        int n = 0;
        for (Link link : this.dotData.getLinks()) {
            if (link.isInvis()) continue;
            if (link.contains(iEntity)) {
                ++n;
            }
            if (n <= 1) continue;
            return false;
        }
        return n == 1;
    }

    private static HtmlColor getColor(ColorParam colorParam, Stereotype stereotype, ISkinParam iSkinParam) {
        String string = stereotype == null ? null : stereotype.getLabel();
        return new Rose().getHtmlColor(iSkinParam, colorParam, string);
    }

    private Cluster getCluster(IEntity iEntity) {
        for (Cluster cluster : this.getBibliotekon().allCluster()) {
            if (cluster.getGroup() != iEntity) continue;
            return cluster;
        }
        throw new IllegalArgumentException(iEntity.toString());
    }

    private Cluster getCluster2(IEntity iEntity) {
        for (Cluster cluster : this.getBibliotekon().allCluster()) {
            if (iEntity != cluster.getGroup()) continue;
            return cluster;
        }
        throw new IllegalArgumentException();
    }

    private IEntityImage error(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Dot Executable: " + file);
        if (file != null) {
            if (!file.exists()) {
                arrayList.add("File does not exist");
            } else if (file.isDirectory()) {
                arrayList.add("It should be an executable, not a directory");
            } else if (!file.isFile()) {
                arrayList.add("Not a valid file");
            } else if (!file.canRead()) {
                arrayList.add("File cannot be read");
            }
        }
        arrayList.add("Cannot find Graphviz. You should try");
        arrayList.add(" ");
        arrayList.add("@startuml");
        arrayList.add("testdot");
        arrayList.add("@enduml");
        arrayList.add(" ");
        arrayList.add(" or ");
        arrayList.add(" ");
        arrayList.add("java -jar plantuml.jar -testdot");
        arrayList.add(" ");
        return new GraphicStrings(arrayList);
    }

    private void printEntities(Collection<ILeaf> collection) {
        for (ILeaf iLeaf : collection) {
            if (iLeaf.isRemoved()) continue;
            this.printEntity(iLeaf);
        }
    }

    private void printEntity(ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage iEntityImage = this.printEntityInternal(iLeaf);
        Dimension2D dimension2D = iEntityImage.calculateDimension(stringBounder);
        Shape shape = new Shape(iEntityImage, iEntityImage.getShapeType(), dimension2D.getWidth(), dimension2D.getHeight(), this.colorSequence, iLeaf.isTop(), iEntityImage.getShield(), iLeaf.getUrls(), iLeaf.getEntityPosition());
        this.dotStringFactory.addShape(shape);
        this.getBibliotekon().putShape(iLeaf, shape);
    }

    private IEntityImage printEntityInternal(ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (iLeaf.getSvekImage() == null) {
            return CucaDiagramFileMakerSvek2.createEntityImageBlock(iLeaf, this.dotData.getSkinParam(), this.dotData.isHideEmptyDescriptionForState(), this.dotData, this.getBibliotekon());
        }
        return iLeaf.getSvekImage();
    }

    public static IEntityImage createEntityImageBlock(ILeaf iLeaf, ISkinParam iSkinParam, boolean bl, PortionShower portionShower, Bibliotekon bibliotekon) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (iLeaf.getEntityType() == LeafType.CLASS || iLeaf.getEntityType() == LeafType.ANNOTATION || iLeaf.getEntityType() == LeafType.ABSTRACT_CLASS || iLeaf.getEntityType() == LeafType.INTERFACE || iLeaf.getEntityType() == LeafType.ENUM) {
            return new EntityImageClass(iLeaf, iSkinParam, portionShower);
        }
        if (iLeaf.getEntityType() == LeafType.NOTE) {
            return new EntityImageNote(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.ACTIVITY) {
            return new EntityImageActivity(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.STATE) {
            if (iLeaf.getEntityPosition() != EntityPosition.NORMAL) {
                Cluster cluster = bibliotekon.getCluster(iLeaf.getParentContainer());
                return new EntityImageStateBorder(iLeaf, iSkinParam, cluster, bibliotekon);
            }
            if (bl && iLeaf.getFieldsToDisplay().size() == 0) {
                return new EntityImageStateEmptyDescription(iLeaf, iSkinParam);
            }
            return new EntityImageState(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.CIRCLE_START) {
            return new EntityImageCircleStart(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.CIRCLE_END) {
            return new EntityImageCircleEnd(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.USECASE) {
            return new EntityImageUseCase(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.BRANCH || iLeaf.getEntityType() == LeafType.STATE_CHOICE) {
            return new EntityImageBranch(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.LOLLIPOP) {
            return new EntityImageLollipopInterface(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.ACTOR) {
            StickMan stickMan = new StickMan(CucaDiagramFileMakerSvek2.getColor(ColorParam.usecaseActorBackground, iLeaf.getStereotype(), iSkinParam), CucaDiagramFileMakerSvek2.getColor(ColorParam.usecaseActorBorder, iLeaf.getStereotype(), iSkinParam), iSkinParam.shadowing() ? 4.0 : 0.0);
            return new EntityImageActor2(iLeaf, iSkinParam, FontParam.USECASE_ACTOR_STEREOTYPE, FontParam.USECASE_ACTOR, stickMan);
        }
        if (iLeaf.getEntityType() == LeafType.BOUNDARY) {
            Boundary boundary = new Boundary(CucaDiagramFileMakerSvek2.getColor(ColorParam.usecaseActorBackground, iLeaf.getStereotype(), iSkinParam), CucaDiagramFileMakerSvek2.getColor(ColorParam.usecaseActorBorder, iLeaf.getStereotype(), iSkinParam), iSkinParam.shadowing() ? 4.0 : 0.0, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0).getThickness());
            return new EntityImageActor2(iLeaf, iSkinParam, FontParam.USECASE_ACTOR_STEREOTYPE, FontParam.USECASE_ACTOR, boundary);
        }
        if (iLeaf.getEntityType() == LeafType.CONTROL) {
            Control control = new Control(CucaDiagramFileMakerSvek2.getColor(ColorParam.usecaseActorBackground, iLeaf.getStereotype(), iSkinParam), CucaDiagramFileMakerSvek2.getColor(ColorParam.usecaseActorBorder, iLeaf.getStereotype(), iSkinParam), iSkinParam.shadowing() ? 4.0 : 0.0, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0).getThickness());
            return new EntityImageActor2(iLeaf, iSkinParam, FontParam.USECASE_ACTOR_STEREOTYPE, FontParam.USECASE_ACTOR, control);
        }
        if (iLeaf.getEntityType() == LeafType.ENTITY_DOMAIN) {
            EntityDomain entityDomain = new EntityDomain(CucaDiagramFileMakerSvek2.getColor(ColorParam.usecaseActorBackground, iLeaf.getStereotype(), iSkinParam), CucaDiagramFileMakerSvek2.getColor(ColorParam.usecaseActorBorder, iLeaf.getStereotype(), iSkinParam), iSkinParam.shadowing() ? 4.0 : 0.0, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0).getThickness());
            return new EntityImageActor2(iLeaf, iSkinParam, FontParam.USECASE_ACTOR_STEREOTYPE, FontParam.USECASE_ACTOR, entityDomain);
        }
        if (iLeaf.getEntityType() == LeafType.COMPONENT) {
            return new EntityImageComponent(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.COMPONENT2) {
            return new EntityImageComponentForDescriptionDiagram(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.OBJECT) {
            return new EntityImageObject(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.SYNCHRO_BAR || iLeaf.getEntityType() == LeafType.STATE_FORK_JOIN) {
            return new EntityImageSynchroBar(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.CIRCLE_INTERFACE) {
            return new EntityImageCircleInterface(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.ARC_CIRCLE) {
            return new EntityImageArcCircle(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.POINT_FOR_ASSOCIATION) {
            return new EntityImageAssociationPoint(iLeaf, iSkinParam);
        }
        if (iLeaf.isGroup()) {
            return new EntityImageGroup(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.EMPTY_PACKAGE) {
            if (iLeaf.getUSymbol() != null) {
                return new EntityImageComponentForDescriptionDiagram(iLeaf, (ISkinParam)new SkinParamForecolored(iSkinParam, HtmlColorUtils.BLACK));
            }
            return new EntityImageEmptyPackage2(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.ASSOCIATION) {
            return new EntityImageAssociation(iLeaf, iSkinParam);
        }
        if (iLeaf.getEntityType() == LeafType.PSEUDO_STATE) {
            return new EntityImagePseudoState(iLeaf, iSkinParam);
        }
        throw new UnsupportedOperationException(iLeaf.getEntityType().toString());
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
        for (ILeaf iLeaf : this.dotData.getLeafs()) {
            if (this.dotData.getTopParent() != iLeaf.getParentContainer()) continue;
            arrayList.add(iLeaf);
        }
        return arrayList;
    }

    private void printGroups(IGroup iGroup) throws IOException {
        for (IGroup iGroup2 : this.dotData.getGroupHierarchy().getChildrenGroups(iGroup)) {
            if (iGroup2.isRemoved()) continue;
            if (this.dotData.isEmpty(iGroup2) && iGroup2.zgetGroupType() == GroupType.PACKAGE) {
                ILeaf iLeaf = this.entityFactory.createLeaf(iGroup2.getCode(), iGroup2.getDisplay(), LeafType.EMPTY_PACKAGE, iGroup2.getParentContainer(), null);
                iLeaf.setUSymbol(iGroup2.getUSymbol());
                if (iGroup2.getSpecificBackColor() == null) {
                    iLeaf.setSpecificBackcolor(this.dotData.getSkinParam().getBackgroundColor());
                } else {
                    iLeaf.setSpecificBackcolor(iGroup2.getSpecificBackColor());
                }
                this.printEntity(iLeaf);
                continue;
            }
            this.printGroup(iGroup2);
        }
    }

    private void printGroup(IGroup iGroup) throws IOException {
        if (iGroup.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        int n = 0;
        int n2 = 0;
        TextBlock textBlock = this.getTitleBlock(iGroup);
        TextBlock textBlock2 = this.getStereoBlock(iGroup);
        TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
        Dimension2D dimension2D = textBlock3.calculateDimension(stringBounder);
        if (dimension2D.getWidth() > 0.0) {
            List<Member> list = iGroup.getFieldsToDisplay();
            TextBlock textBlock4 = list.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list, FontParam.STATE_ATTRIBUTE, this.dotData.getSkinParam());
            Dimension2D dimension2D2 = textBlock4.calculateDimension(stringBounder);
            double d = dimension2D2.getHeight();
            double d2 = dimension2D2.getWidth();
            double d3 = d > 0.0 ? 5.0 : 0.0;
            n = (int)Math.max(dimension2D.getWidth(), d2);
            n2 = (int)(dimension2D.getHeight() + d + d3);
        }
        this.dotStringFactory.openCluster(iGroup, n, n2, textBlock, textBlock2);
        this.printEntities(iGroup.getLeafsDirect());
        this.printGroups(iGroup);
        this.dotStringFactory.closeCluster();
    }

    private TextBlock getTitleBlock(IGroup iGroup) {
        String string;
        Display display = iGroup.getDisplay();
        String string2 = string = iGroup.getStereotype() == null ? null : iGroup.getStereotype().getLabel();
        if (display == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        FontParam fontParam = iGroup.zgetGroupType() == GroupType.STATE ? FontParam.STATE : FontParam.PACKAGE;
        return TextBlockUtils.create(display, new FontConfiguration(this.dotData.getSkinParam().getFont(fontParam, string), this.dotData.getSkinParam().getFontHtmlColor(fontParam, string)), HorizontalAlignment.CENTER, this.dotData.getSkinParam());
    }

    private TextBlock getStereoBlock(IGroup iGroup) {
        if (iGroup.getStereotype() == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        List<String> list = iGroup.getStereotype().getLabels();
        if (list == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        String string = iGroup.getStereotype().getLabel();
        FontParam fontParam = FontParam.COMPONENT_STEREOTYPE;
        return TextBlockUtils.create(new Display(list), new FontConfiguration(this.dotData.getSkinParam().getFont(fontParam, string), this.dotData.getSkinParam().getFontHtmlColor(fontParam, string)), HorizontalAlignment.CENTER, this.dotData.getSkinParam());
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(emptyImageBuilder.getGraphics2D());
    }
}

