/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InnerActivity
implements IEntityImage {
    private final IEntityImage im;
    private final HtmlColor borderColor;
    private final boolean shadowing;
    private final HtmlColor backColor;
    public static final double THICKNESS_BORDER = 1.5;

    public InnerActivity(IEntityImage iEntityImage, HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl) {
        this.im = iEntityImage;
        this.backColor = htmlColor2;
        this.borderColor = htmlColor;
        this.shadowing = bl;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        uGraphic = uGraphic.apply(new UChangeBackColor(this.backColor)).apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5));
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight(), 25.0, 25.0);
        if (this.shadowing) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic.draw(uRectangle);
        uGraphic = uGraphic.apply(new UStroke());
        this.im.drawU(uGraphic);
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.im.getBackcolor();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.im.calculateDimension(stringBounder);
        return dimension2D;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public boolean isHidden() {
        return this.im.isHidden();
    }

    @Override
    public final List<Url> getUrls() {
        return Collections.emptyList();
    }
}

