/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.ULineFlush;
import net.sourceforge.plantuml.activitydiagram3.ftile.ULineMergeable;
import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicLineMerger
extends UGraphicDelegator {
    private final double dx;
    private final double dy;
    private List<MyLine> pendingLines;

    public UGraphicLineMerger(UGraphic uGraphic) {
        this(uGraphic, 0.0, 0.0, new ArrayList<MyLine>());
    }

    public UGraphicLineMerger(UGraphic uGraphic, double d, double d2, List<MyLine> list) {
        super(uGraphic);
        this.dx = d;
        this.dy = d2;
        this.pendingLines = list;
    }

    @Override
    public void draw(UShape uShape) {
        if (uShape instanceof ULineMergeable) {
            MyLine myLine = new MyLine(this.getLine((ULineMergeable)uShape), this.getParam());
            this.addLine(myLine);
        } else if (uShape instanceof ULineFlush) {
            this.printPendingLine();
        } else {
            this.getUg().draw(uShape);
        }
    }

    private void addLine(MyLine myLine) {
        if (this.pendingLines.size() == 0) {
            this.pendingLines.add(myLine);
            return;
        }
        int n = this.pendingLines.size() - 1;
        MyLine myLine2 = this.pendingLines.get(n);
        MyLine myLine3 = myLine.merge(myLine2);
        if (myLine3 == null) {
            this.pendingLines.add(myLine);
        } else {
            this.pendingLines.set(n, myLine3);
        }
    }

    private void printPendingLine() {
        for (MyLine myLine : this.pendingLines) {
            UGraphicLineMerger.printLine(this.getUg().apply(new UTranslate(-this.dx, -this.dy)), myLine);
        }
        this.pendingLines.clear();
    }

    private static void printLine(UGraphic uGraphic, MyLine myLine) {
        uGraphic = uGraphic.apply(new UChangeColor(myLine.param.getColor())).apply(myLine.param.getStroke());
        ULine uLine = new ULine(myLine.getX2() - myLine.getX1(), 0.0);
        ULine uLine2 = new ULine(0.0, myLine.getY2() - myLine.getY1());
        uGraphic.apply(new UTranslate(myLine.getX1(), myLine.getY1())).draw(uLine);
        uGraphic.apply(new UTranslate(myLine.getX2(), myLine.getY1())).draw(uLine2);
    }

    private Line2D getLine(ULineMergeable uLineMergeable) {
        return new Line2D.Double(this.dx, this.dy, this.dx + uLineMergeable.getDX(), this.dy + uLineMergeable.getDY());
    }

    @Override
    public UGraphic apply(UChange uChange) {
        double d = this.dx;
        double d2 = this.dy;
        if (uChange instanceof UTranslate) {
            d += ((UTranslate)uChange).getDx();
            d2 += ((UTranslate)uChange).getDy();
        }
        return new UGraphicLineMerger(this.getUg().apply(uChange), d, d2, this.pendingLines);
    }

    static class MyLine {
        private final Line2D line;
        private final UParam param;

        private MyLine(Line2D line2D, UParam uParam) {
            this.line = line2D;
            this.param = uParam;
        }

        private MyLine merge(MyLine myLine) {
            if (this.getX1() == myLine.getX1() && this.getY1() == myLine.getY1()) {
                return new MyLine(new Line2D.Double(this.getX2(), this.getY2(), myLine.getX2(), myLine.getY2()), this.param);
            }
            if (this.getX1() == myLine.getX2() && this.getY1() == myLine.getY2()) {
                return new MyLine(new Line2D.Double(this.getX2(), this.getY2(), myLine.getX1(), myLine.getY1()), this.param);
            }
            return null;
        }

        private double getX1() {
            return this.line.getX1();
        }

        private double getY1() {
            return this.line.getY1();
        }

        private double getX2() {
            return this.line.getX2();
        }

        private double getY2() {
            return this.line.getY2();
        }

        public String toString() {
            return "" + this.getX1() + "-" + this.getY1() + " --> " + this.getX2() + "-" + this.getY2();
        }
    }
}

