/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageActor2
extends AbstractEntityImage {
    private final TextBlock stickman;
    private final TextBlock name;
    private final TextBlock stereo;
    private final List<Url> url;

    public EntityImageActor2(ILeaf iLeaf, ISkinParam iSkinParam, FontParam fontParam, FontParam fontParam2, TextBlock textBlock) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.name = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), fontParam2, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), fontParam2, stereotype)), HorizontalAlignment.CENTER, iSkinParam);
        this.stickman = textBlock;
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), fontParam, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), fontParam, null)), HorizontalAlignment.CENTER, iSkinParam);
        this.url = iLeaf.getUrls();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getStereoDimension(stringBounder);
        Dimension2D dimension2D3 = this.stickman.calculateDimension(stringBounder);
        return Dimension2DDouble.mergeLayoutT12B3(dimension2D2, dimension2D3, dimension2D);
    }

    private Dimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    public final void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.stickman.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getStereoDimension(stringBounder);
        Dimension2D dimension2D3 = this.calculateDimension(stringBounder);
        Dimension2D dimension2D4 = this.name.calculateDimension(stringBounder);
        double d = (dimension2D3.getWidth() - dimension2D.getWidth()) / 2.0;
        double d2 = dimension2D2.getHeight();
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        this.stickman.drawU(uGraphic.apply(new UTranslate(d, d2)));
        double d3 = (dimension2D3.getWidth() - dimension2D4.getWidth()) / 2.0;
        double d4 = dimension2D.getHeight() + dimension2D2.getHeight();
        this.name.drawU(uGraphic.apply(new UTranslate(d3, d4)));
        if (this.stereo != null) {
            double d5 = (dimension2D3.getWidth() - dimension2D2.getWidth()) / 2.0;
            this.stereo.drawU(uGraphic.apply(new UTranslate(d5, 0.0)));
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

