/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageCircleInterface
extends AbstractEntityImage {
    private static final int SIZE = 16;
    private final TextBlock name;
    private final TextBlock stereo;
    private final List<Url> url;

    public EntityImageCircleInterface(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.name = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.COMPONENT, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.COMPONENT, stereotype)), HorizontalAlignment.CENTER, iSkinParam);
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, null)), HorizontalAlignment.CENTER, iSkinParam);
        this.url = iLeaf.getUrls();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getStereoDimension(stringBounder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(16.0, 16.0);
        return Dimension2DDouble.mergeLayoutT12B3(dimension2D2, dimension2DDouble, dimension2D);
    }

    public final void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getStereoDimension(stringBounder);
        Dimension2D dimension2D2 = this.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.name.calculateDimension(stringBounder);
        double d = (dimension2D2.getWidth() - 16.0) / 2.0;
        double d2 = dimension2D.getHeight();
        UEllipse uEllipse = new UEllipse(16.0, 16.0);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UStroke(2.0));
        uGraphic = uGraphic.apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.componentInterfaceBackground, this.getStereo()))).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.componentInterfaceBorder, this.getStereo())));
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        uGraphic.apply(new UTranslate(d, d2)).draw(uEllipse);
        uGraphic = uGraphic.apply(new UStroke());
        double d3 = (dimension2D2.getWidth() - dimension2D3.getWidth()) / 2.0;
        double d4 = 16.0 + dimension2D.getHeight();
        this.name.drawU(uGraphic.apply(new UTranslate(d3, d4)));
        if (this.stereo != null) {
            double d5 = (dimension2D2.getWidth() - dimension2D.getWidth()) / 2.0;
            this.stereo.drawU(uGraphic.apply(new UTranslate(d5, 0.0)));
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    private Dimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

