/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.EntityImageClassHeader2;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicHorizontalLine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageClass
extends AbstractEntityImage {
    private final TextBlock body;
    private final int shield;
    private final EntityImageClassHeader2 header;
    private final List<Url> url;
    private final TextBlock mouseOver;
    private final double roundCorner;
    private final LineConfigurable lineConfig;

    public EntityImageClass(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iSkinParam);
        this.lineConfig = iLeaf;
        this.roundCorner = iSkinParam.getRoundCorner();
        this.shield = iLeaf.hasNearDecoration() ? 16 : 0;
        this.body = iLeaf.getBody(portionShower).asTextBlock(FontParam.CLASS_ATTRIBUTE, iSkinParam);
        this.header = new EntityImageClassHeader2(iLeaf, iSkinParam, portionShower);
        this.url = iLeaf.getUrls();
        this.mouseOver = iLeaf.getMouseOver() == null ? null : iLeaf.getMouseOver().asTextBlock(FontParam.CLASS_ATTRIBUTE, iSkinParam);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.header.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.body == null ? new Dimension2DDouble(0.0, 0.0) : this.body.calculateDimension(stringBounder);
        double d = Math.max(dimension2D2.getWidth(), dimension2D.getWidth());
        double d2 = dimension2D2.getHeight() + dimension2D.getHeight();
        return new Dimension2DDouble(d, d2);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url.size() > 0 && !this.url.get(0).isMember()) {
            uGraphic.startUrl(this.url.get(0));
        }
        this.drawInternal(uGraphic);
        if (this.mouseOver != null) {
            // empty if block
        }
        if (this.url.size() > 0 && !this.url.get(0).isMember()) {
            uGraphic.closeAction();
        }
    }

    private void drawInternal(UGraphic uGraphic) {
        HtmlColor htmlColor;
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.header.calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d, d2, this.roundCorner, this.roundCorner);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        if ((htmlColor = this.lineConfig.getSpecificLineColor()) == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor));
        HtmlColor htmlColor2 = this.getEntity().getSpecificBackColor();
        if (htmlColor2 == null) {
            htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor2));
        UStroke uStroke = this.getStroke();
        uGraphic.apply(uStroke).apply(new UTranslate(0.0, 0.0)).draw(uRectangle);
        this.header.drawU(uGraphic, dimension2D.getWidth(), dimension2D2.getHeight());
        if (this.body != null) {
            UGraphicHorizontalLine uGraphicHorizontalLine = new UGraphicHorizontalLine(uGraphic, 0.0, d, uStroke);
            this.body.drawU(uGraphicHorizontalLine.apply(new UTranslate(0.0, dimension2D2.getHeight())));
        }
    }

    private UStroke getStroke() {
        UStroke uStroke = this.lineConfig.getSpecificLineStroke();
        if (uStroke == null) {
            uStroke = new UStroke(1.5);
        }
        return uStroke;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return this.shield;
    }
}

