/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageStateEmptyDescription
extends AbstractEntityImage {
    private final TextBlock desc;
    private final List<Url> url;
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 40;

    public EntityImageStateEmptyDescription(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.desc = TextBlockUtils.create(iEntity.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.STATE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.STATE, stereotype)), HorizontalAlignment.CENTER, iSkinParam);
        Display display = new Display();
        for (Member member : iEntity.getFieldsToDisplay()) {
            display = display.addAll(Display.getWithNewlines(member.getDisplay(true)));
        }
        this.url = iEntity.getUrls();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = Dimension2DDouble.delta(dimension2D, 10.0);
        return Dimension2DDouble.atLeast(dimension2D2, 50.0, 40.0);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.desc.calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d, d2, 25.0, 25.0);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UStroke(1.5)).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo())));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        uGraphic.draw(uRectangle);
        double d3 = (d - dimension2D2.getWidth()) / 2.0;
        double d4 = (d2 - dimension2D2.getHeight()) / 2.0;
        this.desc.drawU(uGraphic.apply(new UTranslate(d3, d4)));
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

