/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockable;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.MinMaxMutable;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LimitFinder
implements UGraphic {
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final MinMaxMutable minmax;

    public UGraphic apply(UChange uChange) {
        if (uChange instanceof UTranslate) {
            return new LimitFinder(this.stringBounder, this.minmax, this.translate.compose((UTranslate)uChange));
        }
        if (uChange instanceof UStroke) {
            return new LimitFinder(this);
        }
        if (uChange instanceof UChangeBackColor) {
            return new LimitFinder(this);
        }
        if (uChange instanceof UChangeColor) {
            return new LimitFinder(this);
        }
        throw new UnsupportedOperationException();
    }

    public LimitFinder(StringBounder stringBounder, boolean bl) {
        this(stringBounder, MinMaxMutable.getEmpty(bl), new UTranslate());
    }

    private LimitFinder(StringBounder stringBounder, MinMaxMutable minMaxMutable, UTranslate uTranslate) {
        this.stringBounder = stringBounder;
        this.minmax = minMaxMutable;
        this.translate = uTranslate;
    }

    private LimitFinder(LimitFinder limitFinder) {
        this(limitFinder.stringBounder, limitFinder.minmax, limitFinder.translate);
    }

    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public UParam getParam() {
        return new UParamNull();
    }

    public void draw(UShape uShape) {
        double d = this.translate.getDx();
        double d2 = this.translate.getDy();
        if (uShape instanceof UText) {
            this.drawText(d, d2, (UText)uShape);
        } else if (uShape instanceof ULine) {
            this.drawULine(d, d2, (ULine)uShape);
        } else if (uShape instanceof UEllipse) {
            this.drawEllipse(d, d2, (UEllipse)uShape);
        } else if (uShape instanceof UPolygon) {
            this.drawUPolygon(d, d2, (UPolygon)uShape);
        } else if (uShape instanceof UPath) {
            this.drawUPath(d, d2, (UPath)uShape);
        } else if (uShape instanceof URectangle) {
            this.drawRectangle(d, d2, (URectangle)uShape);
        } else if (uShape instanceof UEmpty) {
            this.drawEmpty(d, d2, (UEmpty)uShape);
        } else if (uShape instanceof TextBlockable) {
            TextBlock textBlock = ((TextBlockable)uShape).asTextBlock();
            textBlock.drawU(this);
        } else {
            throw new UnsupportedOperationException(uShape.getClass().getName());
        }
    }

    private void drawEmpty(double d, double d2, UEmpty uEmpty) {
        this.minmax.addPoint(d, d2);
        this.minmax.addPoint(d + uEmpty.getWidth(), d2 + uEmpty.getHeight());
    }

    private void drawUPath(double d, double d2, UPath uPath) {
        this.minmax.addPoint(d + uPath.getMinX(), d2 + uPath.getMinY());
        this.minmax.addPoint(d + uPath.getMaxX(), d2 + uPath.getMaxY());
    }

    private void drawUPolygon(double d, double d2, UPolygon uPolygon) {
        this.minmax.addPoint(d + uPolygon.getMinX(), d2 + uPolygon.getMinY());
        this.minmax.addPoint(d + uPolygon.getMaxX(), d2 + uPolygon.getMaxY());
    }

    private void drawULine(double d, double d2, ULine uLine) {
        this.minmax.addPoint(d, d2);
        this.minmax.addPoint(d + uLine.getDX(), d2 + uLine.getDY());
    }

    private void drawRectangle(double d, double d2, URectangle uRectangle) {
        this.minmax.addPoint(d, d2);
        this.minmax.addPoint(d + uRectangle.getWidth(), d2 + uRectangle.getHeight());
    }

    private void drawEllipse(double d, double d2, UEllipse uEllipse) {
        this.minmax.addPoint(d, d2);
        this.minmax.addPoint(d + uEllipse.getWidth(), d2 + uEllipse.getHeight());
    }

    private void drawText(double d, double d2, UText uText) {
        Dimension2D dimension2D = this.stringBounder.calculateDimension(uText.getFontConfiguration().getFont(), uText.getText());
        this.minmax.addPoint(d, d2 -= dimension2D.getHeight() - 1.5);
        this.minmax.addPoint(d, d2 + dimension2D.getHeight());
        this.minmax.addPoint(d + dimension2D.getWidth(), d2);
        this.minmax.addPoint(d + dimension2D.getWidth(), d2 + dimension2D.getHeight());
    }

    public ColorMapper getColorMapper() {
        throw new UnsupportedOperationException();
    }

    public void startUrl(Url url) {
    }

    public void closeAction() {
    }

    public void writeImage(OutputStream outputStream, String string, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public MinMax getMinMax() {
        return MinMax.fromMutable(this.minmax);
    }
}

