/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UHorizontalLine
implements UShape {
    private final double skipAtStart;
    private final double skipAtEnd;
    private final TextBlock title;
    private final boolean blankTitle;
    private final UStroke stroke;

    private UHorizontalLine(double d, double d2, TextBlock textBlock, boolean bl, UStroke uStroke) {
        this.skipAtEnd = d2;
        this.skipAtStart = d;
        this.title = textBlock;
        this.blankTitle = bl;
        this.stroke = uStroke;
    }

    public static UHorizontalLine infinite(double d, double d2, UStroke uStroke) {
        return new UHorizontalLine(d, d2, null, false, uStroke);
    }

    public static UHorizontalLine infinite(double d, double d2, TextBlock textBlock, UStroke uStroke) {
        return new UHorizontalLine(d, d2, textBlock, false, uStroke);
    }

    public static UHorizontalLine infinite(UStroke uStroke) {
        return new UHorizontalLine(0.0, 0.0, null, false, uStroke);
    }

    public void drawLine(UGraphic uGraphic, double d, double d2, double d3, UStroke uStroke) {
        UStroke uStroke2;
        double d4 = d2 - d;
        UStroke uStroke3 = uStroke2 = this.stroke == null ? uStroke : this.stroke;
        if (this.title == null) {
            uGraphic.apply(uStroke2).apply(new UTranslate(d + this.skipAtStart, d3)).draw(new ULine(d4 - this.skipAtStart - this.skipAtEnd, 0.0));
            return;
        }
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d5 = (d4 - dimension2D.getWidth()) / 2.0;
        uGraphic.apply(uStroke2).apply(new UTranslate(d + this.skipAtStart - 1.0, d3)).draw(new ULine(d5 - this.skipAtEnd - this.skipAtEnd, 0.0));
        this.drawTitle(uGraphic, d, d2, d3, false);
        uGraphic.apply(uStroke2).apply(new UTranslate(d + this.skipAtStart + d4 - d5, d3)).draw(new ULine(d5 - this.skipAtStart - this.skipAtEnd, 0.0));
    }

    public void drawTitle(UGraphic uGraphic, double d, double d2, double d3, boolean bl) {
        if (this.title == null || this.blankTitle) {
            return;
        }
        double d4 = d2 - d;
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d5 = (d4 - dimension2D.getWidth()) / 2.0;
        double d6 = d + d5;
        double d7 = d3 - dimension2D.getHeight() / 2.0 - 0.5;
        if (bl) {
            uGraphic.apply(this.stroke).apply(new UTranslate(d6, d7)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        }
        this.title.drawU(uGraphic.apply(new UTranslate(d6, d7)));
    }

    public UHorizontalLine blankTitle() {
        return new UHorizontalLine(this.skipAtStart, this.skipAtEnd, this.title, true, this.stroke);
    }

    public UStroke getStroke() {
        return this.stroke;
    }
}

