/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.txt;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.asciiart.TextStringBounder;
import net.sourceforge.plantuml.asciiart.TranslatedCharArea;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.asciiart.UmlCharAreaImpl;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;

public class UGraphicTxt
extends AbstractCommonUGraphic {
    private final UmlCharArea charArea;

    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicTxt(this);
    }

    private UGraphicTxt(UGraphicTxt uGraphicTxt) {
        super(uGraphicTxt);
        this.charArea = uGraphicTxt.charArea;
    }

    public UGraphicTxt() {
        super(new ColorMapperIdentity());
        this.charArea = new UmlCharAreaImpl();
    }

    public StringBounder getStringBounder() {
        return new TextStringBounder();
    }

    public void draw(UShape uShape) {
        if (uShape instanceof UText) {
            UText uText = (UText)uShape;
            int n = this.getDy() / 10 - 1;
            if (uText.getFontConfiguration().containsStyle(FontStyle.WAVE)) {
                this.charArea.drawHLine('^', n, this.getDx(), uText.getText().length());
                this.charArea.drawStringLR(uText.getText(), 0, n + 1);
            } else {
                this.charArea.drawStringLR(uText.getText(), 0, n);
            }
            return;
        }
        throw new UnsupportedOperationException();
    }

    public final UmlCharArea getCharArea() {
        return new TranslatedCharArea(this.charArea, this.getDx(), this.getDy());
    }

    private int getDy() {
        return (int)this.getTranslateY();
    }

    private int getDx() {
        return (int)this.getTranslateX();
    }

    public void startUrl(Url url) {
    }

    public void closeAction() {
    }

    public void writeImage(OutputStream outputStream, String string, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Dimension2D getDimension() {
        return new Dimension2DDouble(0.0, 0.0);
    }
}

