<?php
/**
 * Example Action Plugin: Inserts a button into the toolbar
 *
 * @author Gina Haeussge <osd@foosel.net>
 */


if (!defined('DOKU_INC')) die();
if (!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN', DOKU_INC . 'lib/plugins/');
require_once(DOKU_PLUGIN.'syntax.php');
require_once (DOKU_PLUGIN . 'action.php');
require_once(DOKU_PLUGIN.'sbvr/parser.php');
require_once(DOKU_PLUGIN.'sbvr/utl/xml_generator.php');
require_once(DOKU_PLUGIN.'sbvr/utl/pl_generator.php');
class action_plugin_sbvr extends DokuWiki_Action_Plugin {
 
	/** Constructor */
	function action_plugin_sbvr(){
		
	}
	/**
     * Register the eventhandlers
     */
    public function register(&$controller) {
		 $controller->register_hook('ACTION_ACT_PREPROCESS', 'BEFORE', $this, 'export', array());
		 $controller->register_hook('TPL_ACT_UNKNOWN', 'AFTER', $this, 'export', array());
    }

	/*
     * Prepares terms and facts list for editor
     */
    function export(&$event, $params) {
       global $ACT;
		global $JSINFO;
		global $INFO;
		global $conf;
		global $_GET;

		if($_GET['type']=='xml'){

			// check user's rights
			if ( auth_quickaclcheck($ID) < AUTH_READ ) {
				return false;
			}	
			$gen = new XMLGenerator();
			$fileContent =  $gen->generate(getID());
            
			// We'll be outputting a xml
			header('Content-type: application/xml');

			// It will be called <namespace>_project.xml
			header('Content-Disposition: attachment; filename="'.getNS(getID()).'_project.xml');

			// The XML source is in <namespace>_project.xml on the server
			print($fileContent);
				
			die();
		}
		elseif($_GET['type']=='pl'){

			// check user's rights
			if ( auth_quickaclcheck($ID) < AUTH_READ ) {
				return false;
			}	
			$gen = new PlGenerator();
			$fileContent =  $gen->generate(getID());
			$plFile =  $conf["mediadir"]."/".getNS(getID()).'/facts.pl';
            if ( file_exists($plFile) )
            	unlink($plFile);

			io_saveFile($plFile,$fileContent,false);

			// We'll be outputting a PDF
			header('Content-type: text/plain');

			// It will be called downloaded.pdf
			header('Content-Disposition: attachment; filename="'.getNS(getID()).'/facts.pl');

			// The PDF source is in original.pdf
			readfile($plFile);
				
			die();
		}
		else {
			if($ACT=="show")
				return;

			$parser = new SbvrParser();
		    $tmp = $parser -> prepareTerms(getNS(getID()));
		    if($tmp===true){
		    	$fullTerms=$parser->getPreparedTerms();
				$terms = array();
				foreach($fullTerms as $key=>$term){
					if(!in_array($term['name'], $terms))
						$terms[]=$term['name'];
				}
				sort($terms, SORT_NATURAL);
				$JSINFO['sbvr_terms'] = $terms;

				$tmp = $parser -> prepareFacts(getNS(getID()));
				if($tmp===true){
					$fullFacts=$parser->getPreparedFacts();
					$facts = array();
					foreach($fullFacts as $key=>$fact){
						if(!in_array($fact['term1']." ".$fact['verb']." ".$fact['term2'], $facts))
							$facts[]=$fact['term1']." ".$fact['verb']." ".$fact['term2'];
					}
					sort($facts, SORT_NATURAL);
					$JSINFO['sbvr_facts'] = $facts;
				}
				else{
					$JSINFO['sbvr_error']="Problems with generating facts list occured";
				}
		    }
			else{
				$JSINFO['sbvr_error']="Problems with generating terms list occured";
			}
		}
    }
}
