<?php

if(!defined('DOKU_INC')) define('DOKU_INC',realpath(dirname(__FILE__).'/../../').'/');
require_once(DOKU_INC.'inc/init.php');
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'sbvr/lexer.php');
require_once(DOKU_PLUGIN.'sbvr/utl/xml_generator.php');

class SbvrParser {

	protected $styles = array (
		'UNMATCHED' => "<span>",
		'CATEGORY' => "<span>",
		'NEC' => "<span style=\"color: #FF9900;\">",
		'LOG_OP' => "<span style=\"color: #FF9900;\">",
		'QUANT' => "<span style=\"color: #FF9900;\">",
		'NUMB' => "<span style=\"color: #990099;\">",
		'DIGIT' => "<span style=\"color: #990099;\">",
		'KEYWORD' => "<span style=\"color: #FF9900;\">",
		'THAT' => "<span style=\"color: #FF9900;\">",
		'SYMB' => "<span style=\"color: #FF9900;\">",
		'TERM' => "<span style=\"color: #009900; text-decoration: underline;\">",
		'FACT' => "<span style=\"color: #0000FF; font-style:italic;\">",
		'ATTRIBUTE' => "<span style=\"color: #606060 ;\">",
		'ERROR' => "<span style=\"color: #FF0000 ;\">",
		'COMMENT' => "<span style=\"color: #B0B0B0 ;\">",
		'END' => "</span>"
	);

	protected $lexer;
 
    public function __construct(){
        $this->lexer = new SbvrLexer();
    }
	
	public function prepareTerms($dir){
		return $this->lexer->prepareTerms($dir);
	}
	
	public function prepareFacts($dir){
		return $this->lexer->prepareFacts($dir);
	}

	public function getPrologFacts(){
		return $this->lexer->getPrologFacts();
	}

	//Metoda odpowiednio parsuje otrzymany tekst
	public function run($source, $state){
		$parsedRules = array();
		$rules = explode( "- ", $source );
		
		foreach($rules as $key => $rule){
			$rule=rtrim($rule);
			$rule=ltrim($rule);
			if($rule == ""){
				unset($rules[$key]);
			}
		}
		$graphFiles=array();
		$graph="";
		foreach($rules as $number => $line) { 
			if(stripos($line, "[category]")!==false){
				$line = str_replace("[category]", "", $line);
				$parsedRules[] = "</ol><h2>".$line."</h2><ol>";
				if($graph!="")
					$graphFiles[] = $graph;
				$graph = "";
			}
			elseif(stripos($line, "[comment]")!==false){
				$line = str_replace("[comment]", "", $line);
				$parsedRules[] = $this->styles['COMMENT'].$line.$this->styles['END']."<br>";
			}
			elseif(stripos($line, "[silent_comment]")!==false){
				if($state=="preview"){
					$line = str_replace("[silent_comment]", "", $line);
					$parsedRules[] = $this->styles['COMMENT'].$line.$this->styles['END']."<br>";
				}
			}
			else {
				$tokens = $this->lexer->tokenSource($number, $line, $graph);
				if($tokens[0]===false){
					$line=str_replace($tokens[2],$this->styles['ERROR'].$tokens[2].$this->styles['END'], $line);
					$parsedRules[] = "<br>".$tokens[1]." in:<br>".$line;
				}
				else{
					$parsedTokens = $this -> parseSource($tokens[1], $number, $line);
					$parsedLine = implode(" ", $parsedTokens);
					if(in_array("<li>".$parsedLine."</li>", $parsedRules)===true)
						$parsedRules[]='Duplicate expression: '.strip_tags($parsedLine);
					else{
						$parsedRules[] = "<li>".$parsedLine."</li>";
						$graph.=$tokens[2];
					}
				}
			}
		}
		$graphFiles[] = $graph;
		return array("<ol>".implode("", $parsedRules)."</ol>", $graphFiles);
	}

	//Metoda odpowiednio parsuje otrzymany słownik
	public function parseVocab($source, $state){
		$parsedRules = array();
		$source = str_replace("- ","",$source);
		$rules = explode( "\n", $source );
		foreach($rules as $key => $rule){
			$rule=rtrim($rule);
			$rule=ltrim($rule);
			if($rule == ""){
				unset($rules[$key]);
			}
		}
		$parsedRules=array();
		$parsedTerm=array();
		foreach($rules as $number => $line) {
			if(stripos($line, "[category]")!==false){
				$tokens = array(  'match' => str_replace("[category]","",$line),
						'token' => 'CATEGORY');
			}
			elseif(stripos($line, "[comment]")!==false){
				$parsedTerm[] = $this->styles['COMMENT'].str_replace("[comment]","",$line).$this->styles['END'];
				continue;
			}
			elseif(stripos($line, "[silent_comment]")!==false){
				if($state=="preview"){
					$parsedTerm[] = $this->styles['COMMENT'].str_replace("[silent_comment]","",$line).$this->styles['END'];
				}
				continue;
			}
			elseif(strpos($line,"*")!==false){
				$tokens = array(  'match' => $line,
						'token' => 'ATTRIBUTE');
			}
			else{
				$tokens = array(  'match' => $line,
						'token' => 'TERM');
			}
	
			$parsedLine = $this->styles[$tokens['token']].$tokens['match'].$this->styles['END'];
			if($tokens['token']=='TERM'){
				$parsedRules = array_merge($parsedRules, $parsedTerm);
				$parsedTerm=array();
				if(in_array("<h4>".$parsedLine."<h4>", $parsedTerm)===true)
					$parsedTerm[]='Duplicate term: '.$tokens['match'];
				else
					$parsedTerm[] = "<h4>".$parsedLine."<h4>";
			}
			elseif($tokens['token']=='ATTRIBUTE'){
				$parsedLine=str_replace("*","",$parsedLine);
				if(in_array("<ul><li>".$parsedLine."</li></ul>", $parsedTerm)===true)
					$parsedTerm[]='Duplicate property: '.str_replace("*","",$tokens['match']);
				else
					$parsedTerm[] = "<ul><li>".$parsedLine."</li></ul>";
			}
			elseif($tokens['token']=='CATEGORY'){
				$parsedTerm[] = "<h2>".$parsedLine."<h2>";
			}
			
		}
		$parsedRules = array_merge($parsedRules, $parsedTerm);
		
		return implode("", $parsedRules);
	}

	protected function parseSource($tokens){
		$parsedTokens = array();

		foreach($tokens as $key => $token){
			$parsedTokens[] = $this->styles[$token['token']].$token['match'].$this->styles['END'];
		}
		return $parsedTokens;
	}

	public function getPreparedTerms(){
		return $this->lexer->terms;
	}

	public function getPreparedFacts(){
		return $this->lexer->facts;
	}

}

