/**
 * Add button action for your toolbar button
 *
 * @param  {jQuery}   $btn  Button element to add the action to
 * @param  {Array}    props Associative array of button properties
 * @param  {string}   edid  ID of the editor textarea
 * @return {boolean}  If button should be appended

function addBtnActionClick($btn, props, edid) {
    $btn.click(function() {
        	alert(JSINFO.namespace.concat(':facts'));
        return false;
    });
 
    return true;
}
var placeHolder = document.getElementById('dokuwiki__header');
console.log(placeHolder);


// add a new toolbar button, but first check if there is a toolbar
if (window.toolbar != undefined) {
    window.toolbar[window.toolbar.length] = {
        "type":"Click", // we have a new type that links to the function
        "title":"Hey Click me!",
        "icon":"../../plugins/loki/prolog.png",
    };
}
 */



jQuery(document).ready(function() {

    // Start with disabled submit button
    jQuery(".addnewpage :submit").prop("disabled", true);
    // Then enable it when a title is entered
    jQuery(".addnewpage input[name='title']").keyup(function(){
        var $submit = jQuery(this).parent("form").find(":submit");
        if (jQuery(this).val().length > 0) {
            $submit.removeAttr("disabled");
        } else {
            // For when the user deletes the text
            $submit.attr("disabled", "disabled");
        }
    });
    // Change the form's page-ID field on submit
    $editform = jQuery(".addnewpage form").submit(function(e) {

        // Build the new page ID and save in hidden form field
        var title = jQuery(this).find("input[name='title']");

	jQuery.post( "lib/plugins/sbvr/creator.php", {projectName: title.val(), namespace: JSINFO.namespace}, function( data ) { 
		var url = document.URL.substr(0,document.URL.indexOf("?"))+"?id="+data;
		console.log(data);
		window.location=url;
	
});

        // Clean up the form vars, just to make the resultant URL a bit nicer
        title.prop("disabled", true);

        return false;
    });

});




if(window.toolbar!=undefined)
{
	if(JSINFO.id==JSINFO.namespace.concat(':terms'))
		toolbar[toolbar.length] = {"type":"format",
                             "title":"Example SBVR terms dictionary entry",
                             "icon":"../../plugins/sbvr/sbvrExample.png",
                             "key":"",
                             "open": "",
							 "sample": "\n - [category] Example terms category \n - example term \n * Description: Example term's description \n * Other attribue: Example term's other property \n",
                             "close":""};
	else if(JSINFO.id==JSINFO.namespace.concat(':facts'))
		toolbar[toolbar.length] = {"type":"format",
                             "title":"Example SBVR facts dictionary entry",
                             "icon":"../../plugins/sbvr/sbvrExample.png",
                             "key":"",
                             "open": "",
							 "sample": "\n - [category] Example facts category \n - example term is needed  \n",
                             "close":""};
	else if(JSINFO.id==JSINFO.namespace.concat(':rules'))
		toolbar[toolbar.length] = {"type":"format",
                             "title":"Example SBVR rules dictionary entry",
                             "icon":"../../plugins/sbvr/sbvrExample.png",
                             "key":"",
                             "open": "",
							 "sample": "\n - [category] Example rules category \n - It is necessary that at least one example term is needed. \n",
                             "close":""};
}

//Adding terms and facts lists buttons
if(window.toolbar!=undefined)
{
	//if everything went ok with generating both lists
	if(JSINFO.sbvr_error==null){

		//there is no need to add those buttons for terms dictionary editor
		if(JSINFO.sbvr_terms!=null && JSINFO.id!=JSINFO.namespace.concat(':terms')){
			if(JSINFO.sbvr_terms.length>0){
				toolbar[toolbar.length] = {"type":"picker",
		        	"title":"Terms list",
		        	"icon":"../../plugins/sbvr/listT.png",
		        	"key":"",
		        	"list": JSINFO.sbvr_terms,
		        	"icobase":"../plugins/sbvr/"};
			}
			//facts list button should be added only to rules dictionary editor
			if(JSINFO.sbvr_terms!=null && JSINFO.id==JSINFO.namespace.concat(':rules')){
				if(JSINFO.sbvr_facts.length>0){
					toolbar[toolbar.length] = {"type":"picker",
				    	"title":"Facts list",
				    	"icon":"../../plugins/sbvr/listF.png",
				    	"key":"",
				    	"list": JSINFO.sbvr_facts,
				    	"icobase":"../plugins/sbvr/"};
				}
			}
		}
	}

}


function jsEscape(text){
    var re=new RegExp("\\\\","g");
    text=text.replace(re,"\\\\");
    re=new RegExp("'","g");
    text=text.replace(re,"\\'");
    re=new RegExp('"',"g");
    text=text.replace(re,'\\"');
    re=new RegExp("\\\\\\\\n","g");
    text=text.replace(re,"\\n");
    return text;
}

