<?php
/**
 *
 * Syntax: <TEST> - will be replaced with "Hello World!"
 * 
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Christopher Smith <chris@jalakai.co.uk>
 */
 
if(!defined('DOKU_INC')) define('DOKU_INC',realpath(dirname(__FILE__).'/../../').'/');
require_once(DOKU_INC.'inc/init.php');
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'sbvr/parser.php');
require_once(DOKU_PLUGIN.'syntax.php');
 
/**
 * All DokuWiki plugins to extend the parser/rendering mechanism
 * need to inherit from this class
 */
class syntax_plugin_sbvr extends DokuWiki_Syntax_Plugin {
 
    var $tempdir = "lib/plugins/sbvr/tmp";
 
   /**
    * Get the type of syntax this plugin defines.
    *
    * @param none
    * @return String <tt>'substition'</tt> (i.e. 'substitution').
    * @public
    * @static
    */
    function getType(){
        return 'substition';
    }
 
    /**
     * What kind of syntax do we allow (optional)
     */
//    function getAllowedTypes() {
//        return array();
//    }
 
   /**
    * Define how this plugin is handled regarding paragraphs.
    *
    * <p>
    * This method is important for correct XHTML nesting. It returns
    * one of the following values:
    * </p>
    * <dl>
    * <dt>normal</dt><dd>The plugin can be used inside paragraphs.</dd>
    * <dt>block</dt><dd>Open paragraphs need to be closed before
    * plugin output.</dd>
    * <dt>stack</dt><dd>Special case: Plugin wraps other paragraphs.</dd>
    * </dl>
    * @param none
    * @return String <tt>'block'</tt>.
    * @public
    * @static
    */
    function getPType(){
        return 'normal';
    }
 
   /**
    * Where to sort in?
    *
    * @param none
    * @return Integer <tt>6</tt>.
    * @public
    * @static
    */
    function getSort(){
        return 999;
    }
 
 
   /**
    * Connect lookup pattern to lexer.
    *
    * @param $aMode String The desired rendermode.
    * @return none
    * @public
    * @see render()
    */
    function connectTo($mode) {
//    $this->Lexer->addSpecialPattern('.*',$mode,'plugin_sbvr');
      $this->Lexer->addEntryPattern('<sbvr.*?>(?=.*?</sbvr>)',$mode,'plugin_sbvr');
    }
 
    function postConnect() {
      $this->Lexer->addExitPattern('</sbvr>','plugin_sbvr');
    }
 
 
   /**
    * Handler to prepare matched data for the rendering process.
    *
    * <p>
    * The <tt>$aState</tt> parameter gives the type of pattern
    * which triggered the call to this method:
    * </p>
    * <dl>
    * <dt>DOKU_LEXER_ENTER</dt>
    * <dd>a pattern set by <tt>addEntryPattern()</tt></dd>
    * <dt>DOKU_LEXER_MATCHED</dt>
    * <dd>a pattern set by <tt>addPattern()</tt></dd>
    * <dt>DOKU_LEXER_EXIT</dt>
    * <dd> a pattern set by <tt>addExitPattern()</tt></dd>
    * <dt>DOKU_LEXER_SPECIAL</dt>
    * <dd>a pattern set by <tt>addSpecialPattern()</tt></dd>
    * <dt>DOKU_LEXER_UNMATCHED</dt>
    * <dd>ordinary text encountered within the plugin's syntax mode
    * which doesn't match any pattern.</dd>
    * </dl>
    * @param $aMatch String The text matched by the patterns.
    * @param $aState Integer The lexer state for the match.
    * @param $aPos Integer The character position of the matched text.
    * @param $aHandler Object Reference to the Doku_Handler object.
    * @return Integer The current lexer state for the match.
    * @public
    * @see render()
    * @static
    */
    function handle($match, $state, $pos, &$handler){
        switch ($state) {
          case DOKU_LEXER_ENTER : 
            return null;
            break;
          case DOKU_LEXER_MATCHED :
            return array($state, $match);
            break;
          case DOKU_LEXER_UNMATCHED :
            return array($state, $match);
            break;
          case DOKU_LEXER_EXIT :
            return null;            
            break;
          case DOKU_LEXER_SPECIAL :
            break;
        }
        return $match;
    }
 
   /**
    * Handle the actual output creation.
    *
    * <p>
    * The method checks for the given <tt>$aFormat</tt> and returns
    * <tt>FALSE</tt> when a format isn't supported. <tt>$aRenderer</tt>
    * contains a reference to the renderer object which is currently
    * handling the rendering. The contents of <tt>$aData</tt> is the
    * return value of the <tt>handle()</tt> method.
    * </p>
    * @param $aFormat String The output format to generate.
    * @param $aRenderer Object A reference to the renderer object.
    * @param $aData Array The data created by the <tt>handle()</tt>
    * method.
    * @return Boolean <tt>TRUE</tt> if rendered successfully, or
    * <tt>FALSE</tt> otherwise.
    * @public
    * @see handle()
    */
    function render($mode, &$renderer, $data) {
        global $conf;
		global $INFO;
        global $ID;
        global $REV;
        global $ACT;
        $renderer->info["cache"] = false;

        if($mode == 'xhtml'){
            
            list($state, $match) = $data;
            switch ($state) 
			  {
/*
                 case DOKU_LEXER_MATCHED :
     $button_val = 'ok';
                $form = '<div class="addnewpage" style="float: right; border-style: solid; border-width:2px; padding: 2px 2px 2px 2px;">'.DOKU_LF
                    .DOKU_TAB.'<form name="addnewpage" method="get" action="'.DOKU_BASE.DOKU_SCRIPT.'" accept-charset="'.$lang['encoding'].'">'.DOKU_LF
                    .DOKU_TAB.DOKU_TAB.'Create new SBVR project <br>'.DOKU_LF
                    .DOKU_TAB.DOKU_TAB.'<input class="edit" type="text" name="title" size="20" maxlength="255" tabindex="2" />'.DOKU_LF
                    .DOKU_TAB.DOKU_TAB.'<input type="hidden" name="do" value="edit" />'.DOKU_LF
                    .DOKU_TAB.DOKU_TAB.'<input type="hidden" name="id" />'.DOKU_LF
                    .DOKU_TAB.DOKU_TAB.'<input class="button" type="submit" value="'.$button_val.'" tabindex="3" />'.DOKU_LF
                    .DOKU_TAB.'</form>'.DOKU_LF
                    .'</div>';
                $renderer->doc .= $form;
*/
                case DOKU_LEXER_UNMATCHED :

                $button_val = 'ok';
                $form = '<div class="addnewpage" style="float: right; border-style: solid; border-width:2px; padding: 2px 2px 2px 2px;">'.DOKU_LF
                    .DOKU_TAB.'<form name="addnewpage" method="get" action="'.DOKU_BASE.DOKU_SCRIPT.'" accept-charset="'.$lang['encoding'].'">'.DOKU_LF
                    .DOKU_TAB.DOKU_TAB.'Create new SBVR project <br>'.DOKU_LF
                    .DOKU_TAB.DOKU_TAB.'<input class="edit" type="text" name="title" size="20" maxlength="255" tabindex="2" />'.DOKU_LF
                    .DOKU_TAB.DOKU_TAB.'<input class="button" type="submit" value="'.$button_val.'" tabindex="3" />'.DOKU_LF
                    .DOKU_TAB.'</form>'.DOKU_LF
                    .'</div>';
                $renderer->doc .= $form;

                $page=noNS($ID);
		        if($page!=='terms' && $page!=='facts' && $page!=='rules')
			        break;

//                  $cmd = "java -jar tmp/plantuml.jar tmp/classDiagram.txt";
//		            exec($cmd, $output, $error);

//PRZYGOTOWANIE LISTY TERMÓW
                    $namespace =  getNS(getID());
                    $parser = new SbvrParser();
                    $tmp = $parser -> prepareTerms($namespace);
                        if($tmp!==true){
                            $renderer->doc .= $tmp."<br>".$match;
                            break;
                        }
//UPROSZCZONE PRZETWARZANIE DLA SŁOWNIKA TERMÓW
                    if(noNS(getID())=='terms'){
                        $res = $parser->parseVocab($match, $GLOBALS['ACT']);
                        $renderer->doc .= $res;
                        break;
                    }
//PRZYGOTOWANIE LISTY FAKTOW
                    $tmp = $parser -> prepareFacts($namespace);
                        if($tmp!==true){
                            $renderer->doc .= $tmp."<br>".$match;
                            return false;
                        }
                    
//PRZETWARZANIE TEKSTU
                    $res = $parser->run($match, $GLOBALS['ACT']);
                    $renderer->doc .= $res[0];

//PRZYCISK EKSPORTU DANYCH DO XML
                    if($ACT=='show' && noNS(getID())=='rules'){
                        $renderer->doc .= '<br><br><form class="button" method="get" action="'.exportlink(getID(), 'sbvr', array('type' => 'xmi')).'">
	             							 <div align="right">
	             								<input type="submit" value="Export to XML" class="button" />
	              						  		<input type="hidden" name="do" value="export_sbvr" />								
		             							<input type="hidden" name="id" value="'.getID().'" />
                                                <input type="hidden" name="type" value="xml" />
	              							 </div>
								            </form>';
                    }
//PRZYCISK EKSPORTU DANYCH DO SKŁADNI PL WIKI
                    if($ACT=='show' && noNS(getID())=='facts'){
                         $renderer->doc .= '<br><br><form class="button" method="get" action="'.exportlink(getID(), 'sbvr', array('type' => 'pl')).'">
	             							 <div align="right">
	             								<input type="submit" value="Export to PlWiki" class="button" />
	              						  		<input type="hidden" name="do" value="export_sbvr" />								
		             							<input type="hidden" name="id" value="'.getID().'" />
                                                <input type="hidden" name="type" value="pl" />
	              							 </div>
								            </form>';
                    }

//GENEROWANIE WIZUALIZACJI
                    if(noNS(getId())!='terms'){
                        foreach($res[1] as $key => $graph) {
                            $tempfile = $this->tempdir . '/graph_tmp';
                            $file = fopen($tempfile.'.txt', 'w');
					        fwrite($file, "@startuml \n".$graph." \n hide empty members \n hide methods \n @enduml");
				            fclose($file);

                            $md5 = md5_file($tempfile.'.txt');
                            $mediadir = $conf["mediadir"]."/".str_replace(":", "/",$INFO['namespace'] );

					        if( !is_dir($mediadir) )
						        mkdir($mediadir,0755,true);
                            $imagefile = $mediadir.'/graph' . '_' . $md5 . '.png';

					      	if ( !file_exists($imagefile) )
					      	{						   
						        $cmd = "java -Djava.awt.headless=true -Dfile.encoding=UTF-8 -jar ".$this->tempdir."/plantuml.jar -charset UTF-8 " . $tempfile.'.txt';
						        exec($cmd, $output, $error);

						       if ($error != 0)
							    {
								    $renderer->doc .= '---ERROR CREATING GRAPH---';
								    unlink($tempfile);
								    if (file_exists($tempfile.'.png'))
									    unlink($tempfile.'.png');
						          return false;
						       }

						       if (file_exists($imagefile))
								    unlink($imagefile);
							    if ( !copy($tempfile.'.png', $imagefile) )
								    return false;
						
						       unlink($tempfile.'.png');
					      	}

					      	unlink($tempfile.'.txt');
                            $renderer->doc .= "<h2>Graph No: ".($key+1)."</h2>";
						    $renderer->doc .= $renderer->internalmedia($INFO['namespace'].':graph' . '_' . $md5 . '.png');
                        }
                    }
                break;
              }
            return true;
        }
        return false;
    }
}
 
//Setup VIM: ex: et ts=4 enc=utf-8 :
?>
